/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer;

import com.leobeliik.convenientcurioscontainer.ConvenientConfig;
import com.leobeliik.convenientcurioscontainer.common.ConvenientMenu;
import com.leobeliik.convenientcurioscontainer.gui.ConvenientScreen;
import com.leobeliik.convenientcurioscontainer.items.ConvenientItem;
import com.leobeliik.convenientcurioscontainer.network.Networking;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;

@Mod(value="convenientcurioscontainer")
public class ConvenientCuriosContainer {
    public static final String MODID = "convenientcurioscontainer";
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"convenientcurioscontainer");
    static final DeferredItem<Item> CONVENIENT_ITEM = ITEMS.register("convenient_container", () -> new ConvenientItem(new Item.Properties().stacksTo(1)));
    private static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"convenientcurioscontainer");
    public static final Supplier<MenuType<ConvenientMenu>> CONVENIENT_MENU = MENUS.register("convenient_menu", () -> new MenuType(ConvenientMenu::new, FeatureFlags.DEFAULT_FLAGS));

    public ConvenientCuriosContainer(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        ITEMS.register(modEventBus);
        MENUS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::registerScreens);
        modEventBus.addListener(Networking::registerMessages);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConvenientConfig.SPEC);
    }

    private void registerScreens(RegisterMenuScreensEvent event) {
        event.register(CONVENIENT_MENU.get(), ConvenientScreen::new);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept(CONVENIENT_ITEM);
        }
    }

    @SubscribeEvent
    public void onCuriosSlotsModified(SlotModifiersUpdatedEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ConvenientMenu) {
                ConvenientMenu convenientContainer = (ConvenientMenu)abstractContainerMenu;
                convenientContainer.ClearSlots();
            }
        }
    }
}

