/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;

public class DyeRecipesMaker {
    private DyeRecipesMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        DyeRecipesMaker.addSingleColorRecipes(recipes);
        DyeRecipesMaker.addMultipleColorsRecipe(recipes);
        return recipes;
    }

    private static void addMultipleColorsRecipe(List<RecipeHolder<CraftingRecipe>> recipes) {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)Ingredient.of((TagKey)DyeColor.YELLOW.getTag()));
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BACKPACK.get()}));
        ingredients.add((Object)Ingredient.EMPTY);
        ingredients.add((Object)Ingredient.of((TagKey)DyeColor.LIME.getTag()));
        ingredients.add((Object)Ingredient.of((TagKey)DyeColor.BLUE.getTag()));
        ingredients.add((Object)Ingredient.of((TagKey)DyeColor.BLACK.getTag()));
        ItemStack backpackOutput = new ItemStack((ItemLike)ModItems.BACKPACK.get());
        int clothColor = ColorHelper.calculateColor((int)-3382982, (int)-3382982, List.of(DyeColor.YELLOW, DyeColor.LIME));
        int trimColor = ColorHelper.calculateColor((int)-10342886, (int)-10342886, List.of(DyeColor.BLUE, DyeColor.BLACK));
        BackpackWrapper.fromStack(backpackOutput).setColors(clothColor, trimColor);
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 1, ingredients, Optional.empty());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"multiple_colors");
        recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)new ShapedRecipe("", CraftingBookCategory.MISC, pattern, backpackOutput)));
    }

    private static void addSingleColorRecipes(List<RecipeHolder<CraftingRecipe>> recipes) {
        for (DyeColor color : DyeColor.values()) {
            ItemStack backpackOutput = new ItemStack((ItemLike)ModItems.BACKPACK.get());
            BackpackWrapper.fromStack(backpackOutput).setColors(color.getTextureDiffuseColor(), color.getTextureDiffuseColor());
            NonNullList ingredients = NonNullList.create();
            ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BACKPACK.get()}));
            ingredients.add((Object)Ingredient.of((TagKey)color.getTag()));
            ShapedRecipePattern pattern = new ShapedRecipePattern(1, 2, ingredients, Optional.empty());
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)("single_color_" + color.getSerializedName()));
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)new ShapedRecipe("", CraftingBookCategory.MISC, pattern, backpackOutput)));
        }
    }
}

