/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.helper;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

public class Helper {
    public static final Function<Level, Comparator<RecipeHolder<WoodcuttingRecipe>>> RECIPE_COMPARATOR = level -> Comparator.comparing(recipeHolder -> {
        String[] name = Helper.getRegistryPath(((WoodcuttingRecipe)recipeHolder.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()).split("_");
        return name[name.length - 1];
    }).thenComparing(recipe -> Helper.getRegistryName(((WoodcuttingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()));

    public static List<RecipeHolder<WoodcuttingRecipe>> getSortedMatchingRecipes(Level level, Container inventory) {
        return level.getRecipeManager().getAllRecipesFor(ModRecipeTypes.WOODCUTTING).stream().filter(recipe -> ((WoodcuttingRecipe)recipe.value()).matches(new SingleRecipeInput(inventory.getItem(0)), level)).sorted(RECIPE_COMPARATOR.apply(level)).toList();
    }

    public static ResourceLocation getRegistryRL(ItemStack stack) {
        return Helper.getRegistryRL(stack.getItem());
    }

    public static ResourceLocation getRegistryRL(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryRL(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static String getRegistryNamespace(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
    }

    public static String getRegistryPath(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public static String getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    public static void fillItemSet(Set<Item> items, TagKey<Item> tagKey) {
        Helper.getItems(tagKey).forEach(holder -> items.add((Item)holder.value()));
    }

    public static Iterable<Holder<Item>> getItems(TagKey<Item> tagKey) {
        return BuiltInRegistries.ITEM.getTagOrEmpty(tagKey);
    }

    public static boolean isInTag(Item item, TagKey<Item> tagKey) {
        return StreamSupport.stream(Helper.getItems(tagKey).spliterator(), false).anyMatch(holder -> holder.value() == item);
    }

    public static <T> T unsafeNullCast() {
        return null;
    }

    public static boolean isValidPlayer(@Nullable Player player) {
        return player != null;
    }
}

