/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.command;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jline.utils.Levenshtein;
import ovh.corail.woodcutter.command.WoodcuttingJsonRecipe;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.helper.LangKey;

@EventBusSubscriber(modid="corail_woodcutter", bus=EventBusSubscriber.Bus.GAME)
public class CommandWoodcutter {
    private final Set<Item> logs = new HashSet<Item>();
    private final Map<Item, WoodCompo> plankToLog = new HashMap<Item, WoodCompo>();
    private static final String MODID_PARAM = "modid";
    private static final String RECIPE_PARAM = "recipe";
    private static final int PACK_FORMAT = 48;
    private static final Predicate<ItemStack> VANILLA_ITEM = stack -> !stack.isEmpty() && "minecraft".equals(Helper.getRegistryNamespace(stack.getItem()));
    private static final Predicate<ItemStack> NOT_VANILLA_ITEM = stack -> !stack.isEmpty() && !"minecraft".equals(Helper.getRegistryNamespace(stack.getItem()));
    private static final Predicate<String> INVALID_MODID = modid -> modid == null || "minecraft".equals(modid) || !ModList.get().isLoaded(modid) || SupportMods.hasSupport(modid);
    private static final BiPredicate<String, String> ALMOSTLY_SIMILAR_PATH = (s1, s2) -> Levenshtein.distance((CharSequence)s1, (CharSequence)s2, (int)1, (int)0, (int)1, (int)10) <= 3;
    private static final BiFunction<MinecraftServer, String, File> DATAPACK_FOLDER = (server, folder) -> new File(server.getWorldPath(LevelResource.DATAPACK_DIR).toFile(), (String)folder);
    private static final Function<String, File> CONFIG_FOLDER = folder -> new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_woodcutter" + File.separatorChar + folder);
    private static final Function<ResourceLocation, String> RL_TO_NAME = rl -> rl.getPath().replaceAll("/|\\\\", "_");
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_MODID = (ctx, build) -> SharedSuggestionProvider.suggest(ModList.get().applyForEachModContainer(ModContainer::getModId).filter(SupportMods::noSupport).filter(modid -> !"minecraft".equals(modid)), (SuggestionsBuilder)build);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_CRAFTING_RECIPES = (ctx, build) -> SharedSuggestionProvider.suggestResource(((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::id), (SuggestionsBuilder)build);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    private CommandWoodcutter() {
    }

    private int showUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> LangKey.COMMAND_USAGE.getText(new Object[0]), false);
        return 1;
    }

    private int applyDataPack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        String zipName = this.getZipName(modid);
        File configDatapackZip = CONFIG_FOLDER.apply(zipName);
        if (!configDatapackZip.exists()) {
            throw LangKey.DATAPACK_NOT_GENERATED.asCommandException(modid);
        }
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        File destination = DATAPACK_FOLDER.apply(server, zipName);
        if (destination.exists()) {
            this.disableDataPack(server, modid);
            if (!destination.delete()) {
                throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
            }
        }
        try {
            FileUtils.copyFile((File)configDatapackZip, (File)destination);
            PackRepository packRepository = server.getPackRepository();
            packRepository.reload();
            ArrayList selectedPacks = Lists.newArrayList((Iterable)packRepository.getSelectedPacks());
            Pack pack = packRepository.getPack("file/" + this.getZipName(modid));
            selectedPacks.add(pack);
            server.reloadResources(selectedPacks.stream().map(Pack::getId).toList());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> LangKey.DATAPACK_APPLY_SUCCESS.getText(new Object[0]), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_COPY_FAIL.getText(destination.getAbsolutePath()));
        }
    }

    private void disableDataPack(MinecraftServer server, String modid) {
        PackRepository packRepository = server.getPackRepository();
        ArrayList selectedPacks = Lists.newArrayList((Iterable)packRepository.getSelectedPacks());
        Pack pack = packRepository.getPack("file/" + this.getZipName(modid));
        if (pack != null && selectedPacks.contains(pack)) {
            selectedPacks.remove(pack);
            server.reloadResources(selectedPacks.stream().map(Pack::getId).toList());
        }
    }

    private int removeDataPack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        File destination = DATAPACK_FOLDER.apply(server, this.getZipName(modid));
        if (!destination.exists()) {
            throw LangKey.DATAPACK_REMOVE_ABSENT.asCommandException(new Object[0]);
        }
        this.disableDataPack(server, modid);
        if (!destination.delete()) {
            throw LangKey.DATAPACK_REMOVE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> LangKey.DATAPACK_REMOVE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private int generateDataPack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        File recipeFolder;
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        RegistryAccess registryAccess = ((CommandSourceStack)context.getSource()).getLevel().registryAccess();
        this.initPlanksToLogs(server, registryAccess);
        Map<String, WoodcuttingJsonRecipe> recipes = this.getJsonRecipes(this.getCraftingRecipes(server, recipe -> modid.equals(recipe.id().getNamespace()) && NOT_VANILLA_ITEM.test(((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess))), registryAccess);
        if (recipes.isEmpty()) {
            throw LangKey.NO_VALID_RECIPE_FOR_MODID.asCommandException(modid);
        }
        File datapackFolder = CONFIG_FOLDER.apply("corail_woodcutter_" + modid);
        File dataFolder = new File(datapackFolder, "data");
        if (dataFolder.exists()) {
            try {
                FileUtils.cleanDirectory((File)dataFolder);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(recipeFolder = new File(dataFolder, "corail_woodcutter_" + modid + File.separatorChar + RECIPE_PARAM + File.separatorChar + modid)).exists() && !recipeFolder.mkdirs()) {
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FOLDER_CREATE_FAIL.getText(recipeFolder.getAbsolutePath()));
        }
        for (Map.Entry<String, WoodcuttingJsonRecipe> entry : recipes.entrySet()) {
            File file = new File(recipeFolder, entry.getKey() + ".json");
            if (file.exists() && !file.delete()) {
                throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(file.getAbsolutePath()));
            }
            if (this.generateJson(file, entry.getValue().withConditions(new WoodcuttingJsonRecipe.ConditionItem(entry.getValue().result), new WoodcuttingJsonRecipe.ConditionMod(modid), new WoodcuttingJsonRecipe.ConditionMod("corail_woodcutter")))) continue;
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_WRITE_FAIL.getText(file.getAbsolutePath()));
        }
        if (!this.addMcMeta(datapackFolder, modid)) {
            throw LangKey.MCMETA_CREATE_FAIL.asCommandException(new Object[0]);
        }
        try {
            this.toZip(datapackFolder.toPath(), modid);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> LangKey.DATAPACK_GENERATE_SUCCESS.getText(recipes.size()), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.ZIP_CREATE_FAIL.asCommandException(new Object[0]);
        }
    }

    private WoodCompo getWoodCompo(NonNullList<Ingredient> ingredients) {
        Function<Predicate, Ingredient> findIngredient = predic -> ingredients.stream().filter(ing -> !ing.isEmpty() && Arrays.stream(ing.getItems()).allMatch((Predicate<ItemStack>)predic)).findFirst().orElse(null);
        Ingredient plankIngredient = findIngredient.apply(stack -> this.plankToLog.containsKey(stack.getItem()));
        if (plankIngredient != null) {
            HashSet<Item> planks = new HashSet<Item>();
            int vanillaPlanks = 0;
            for (ItemStack stack2 : plankIngredient.getItems()) {
                if (!planks.add(stack2.getItem()) || !VANILLA_ITEM.test(stack2) || ++vanillaPlanks <= 1) continue;
                return WoodCompo.ANY_WOOD;
            }
            if (planks.size() == 1) {
                return this.plankToLog.get(planks.iterator().next());
            }
            WoodCompo compo = this.plankToLog.get(planks.iterator().next());
            return this.getTagForIngredient(plankIngredient).map(tag -> new WoodCompo((ResourceLocation)tag, true, compo.logName(), compo.isLogTag())).orElse(compo);
        }
        Ingredient ingredient = Optional.ofNullable(findIngredient.apply(stack -> this.logs.contains(stack.getItem()))).orElse(findIngredient.apply(stack -> Helper.isInTag(stack.getItem(), (TagKey<Item>)ItemTags.WOODEN_SLABS)));
        if (ingredient != null) {
            String itemName = Helper.getRegistryName(ingredient.getItems()[0].getItem()).replaceAll("_log|_stem|_slab", "_plank");
            WoodCompo compo = this.plankToLog.entrySet().stream().filter(entry -> ALMOSTLY_SIMILAR_PATH.test(Helper.getRegistryName((Item)entry.getKey()), itemName)).findFirst().map(Map.Entry::getValue).orElse(null);
            if (compo != null) {
                return compo;
            }
        }
        return WoodCompo.ANY_WOOD;
    }

    private void initPlanksToLogs(MinecraftServer server, RegistryAccess registryAccess) {
        if (!this.plankToLog.isEmpty()) {
            return;
        }
        Helper.fillItemSet(this.logs, (TagKey<Item>)ItemTags.LOGS);
        BuiltInRegistries.ITEM.stream().filter(entry -> {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey(entry);
            return rl.getPath().endsWith("_log") || rl.getPath().endsWith("_stem");
        }).forEach(this.logs::add);
        this.getCraftingRecipes(server, recipe -> this.isLogToPlankRecipe((RecipeHolder<CraftingRecipe>)recipe, registryAccess)).forEach(logRecipeHolder -> this.plankToLog.computeIfAbsent(((CraftingRecipe)logRecipeHolder.value()).getResultItem((HolderLookup.Provider)registryAccess).getItem(), plank -> {
            ResourceLocation plankName = Helper.getRegistryRL(plank);
            Ingredient ingredient = (Ingredient)((CraftingRecipe)logRecipeHolder.value()).getIngredients().getFirst();
            Optional<ResourceLocation> tagName = this.getTagForIngredient(ingredient);
            if (tagName.isPresent()) {
                return new WoodCompo(plankName, false, tagName.get(), true);
            }
            ItemStack[] stacks = ingredient.getItems();
            Set<ResourceLocation> commonTags = this.getCommonTags(stacks, plankName.getNamespace());
            if (stacks.length == 1) {
                ResourceLocation logName2 = Helper.getRegistryRL(stacks[0]);
                String logPath = logName2.getPath().replace("stripped_", "");
                return commonTags.stream().filter(rl -> ALMOSTLY_SIMILAR_PATH.test(logPath, rl.getPath())).findFirst().map(rl -> new WoodCompo(plankName, false, (ResourceLocation)rl, true)).orElse(new WoodCompo(plankName, false, logName2, false));
            }
            Set logNames = Arrays.stream(stacks).map(ItemStack::getItem).map(Helper::getRegistryRL).collect(Collectors.toSet());
            for (ResourceLocation tagRL : commonTags) {
                if (!logNames.stream().anyMatch(logName -> ALMOSTLY_SIMILAR_PATH.test(logName.getPath().replace("stripped_", ""), tagRL.getPath()))) continue;
                return new WoodCompo(plankName, false, tagRL, true);
            }
            return new WoodCompo(plankName, false, logNames.stream().min(Comparator.comparingInt(rl -> Levenshtein.distance((CharSequence)rl.getPath(), (CharSequence)plankName.getPath()))).orElse(null), false);
        }));
        this.plankToLog.put(Items.ACACIA_PLANKS, WoodCompo.of(Items.ACACIA_PLANKS, (TagKey<Item>)ItemTags.ACACIA_LOGS));
        this.plankToLog.put(Items.BIRCH_PLANKS, WoodCompo.of(Items.BIRCH_PLANKS, (TagKey<Item>)ItemTags.BIRCH_LOGS));
        this.plankToLog.put(Items.DARK_OAK_PLANKS, WoodCompo.of(Items.DARK_OAK_PLANKS, (TagKey<Item>)ItemTags.DARK_OAK_LOGS));
        this.plankToLog.put(Items.JUNGLE_PLANKS, WoodCompo.of(Items.JUNGLE_PLANKS, (TagKey<Item>)ItemTags.JUNGLE_LOGS));
        this.plankToLog.put(Items.OAK_PLANKS, WoodCompo.of(Items.OAK_PLANKS, (TagKey<Item>)ItemTags.OAK_LOGS));
        this.plankToLog.put(Items.SPRUCE_PLANKS, WoodCompo.of(Items.SPRUCE_PLANKS, (TagKey<Item>)ItemTags.SPRUCE_LOGS));
        this.plankToLog.put(Items.CRIMSON_PLANKS, WoodCompo.of(Items.CRIMSON_PLANKS, (TagKey<Item>)ItemTags.CRIMSON_STEMS));
        this.plankToLog.put(Items.WARPED_PLANKS, WoodCompo.of(Items.WARPED_PLANKS, (TagKey<Item>)ItemTags.WARPED_STEMS));
        this.plankToLog.put(Items.MANGROVE_PLANKS, WoodCompo.of(Items.MANGROVE_PLANKS, (TagKey<Item>)ItemTags.MANGROVE_LOGS));
        this.plankToLog.put(Items.CHERRY_PLANKS, WoodCompo.of(Items.CHERRY_PLANKS, (TagKey<Item>)ItemTags.CHERRY_LOGS));
        this.plankToLog.put(Items.BAMBOO_PLANKS, WoodCompo.BAMBOO);
        this.plankToLog.put(Items.BAMBOO_MOSAIC, WoodCompo.of(Items.BAMBOO_MOSAIC, null, false));
        Helper.getItems((TagKey<Item>)ItemTags.PLANKS).forEach(key -> this.plankToLog.computeIfAbsent((Item)key.value(), item -> WoodCompo.of(item, null, false)));
    }

    private Set<ResourceLocation> getCommonTags(ItemStack[] stacks, String namespace) {
        if (stacks.length == 0) {
            return Collections.emptySet();
        }
        Set<ResourceLocation> commonTags = stacks[0].getTags().map(TagKey::location).collect(Collectors.toSet());
        commonTags.removeIf(rl -> !namespace.equals(rl.getNamespace()));
        if (stacks.length > 1) {
            IntStream.range(1, stacks.length).forEach(i -> commonTags.retainAll(stacks[i].getTags().map(TagKey::location).collect(Collectors.toSet())));
        }
        return commonTags;
    }

    private Optional<ResourceLocation> getTagForIngredient(Ingredient ingredient) {
        return Arrays.stream(ingredient.values).filter(v -> v instanceof Ingredient.TagValue).findFirst().map(tagValue -> ((Ingredient.TagValue)tagValue).tag()).map(TagKey::location);
    }

    private List<RecipeHolder<CraftingRecipe>> getCraftingRecipes(MinecraftServer server, Predicate<RecipeHolder<CraftingRecipe>> recipePredicate) {
        return server.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().filter(recipePredicate).collect(Collectors.toList());
    }

    private boolean isLogToPlankRecipe(RecipeHolder<CraftingRecipe> recipeHolder, RegistryAccess registryAccess) {
        if ("minecraft".equals(recipeHolder.id().getNamespace())) {
            return false;
        }
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        if (recipe.getIngredients().size() != 1 || !(recipe instanceof ShapelessRecipe)) {
            return false;
        }
        ItemStack resultItem = recipe.getResultItem((HolderLookup.Provider)registryAccess);
        if (NOT_VANILLA_ITEM.test(resultItem) && (resultItem.is(ItemTags.PLANKS) || Helper.getRegistryPath(resultItem.getItem()).endsWith("_planks"))) {
            Ingredient ingredient = recipe.getIngredients().stream().filter(ing -> !ing.isEmpty()).findFirst().orElse(Ingredient.EMPTY);
            return NOT_VANILLA_ITEM.test(ingredient.getItems()[0]) && this.logs.contains(ingredient.getItems()[0].getItem()) && Arrays.stream(ingredient.getItems()).allMatch(NOT_VANILLA_ITEM);
        }
        return false;
    }

    private String getZipName(String modid) {
        return "corail_woodcutter_" + modid + ".zip";
    }

    private void toZip(Path source, String modid) throws IOException {
        try (final ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(CONFIG_FOLDER.apply(this.getZipName(modid)).toPath(), new OpenOption[0])));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attributes) {
                    if (!visitedPath.toFile().isDirectory()) {
                        String stringPath = visitedPath.toString();
                        ZipEntry zipentry = new ZipEntry(stringPath.endsWith("pack.mcmeta") ? "pack.mcmeta" : stringPath.substring(stringPath.indexOf("data")).replace('\\', '/'));
                        try {
                            outputStream.putNextEntry(zipentry);
                            com.google.common.io.Files.asByteSource((File)visitedPath.toFile()).copyTo((OutputStream)outputStream);
                            outputStream.closeEntry();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private boolean generateJson(File file, WoodcuttingJsonRecipe jsonRecipe) {
        JsonObject json = new JsonObject();
        JsonArray conditions = new JsonArray();
        JsonObject condition1 = new JsonObject();
        condition1.addProperty("type", "neoforge:mod_loaded");
        condition1.addProperty(MODID_PARAM, ((WoodcuttingJsonRecipe.ConditionMod)jsonRecipe.conditions[2]).modid);
        conditions.add((JsonElement)condition1);
        JsonObject condition2 = new JsonObject();
        condition2.addProperty("type", "neoforge:mod_loaded");
        condition2.addProperty(MODID_PARAM, ((WoodcuttingJsonRecipe.ConditionMod)jsonRecipe.conditions[1]).modid);
        conditions.add((JsonElement)condition2);
        JsonObject condition3 = new JsonObject();
        condition3.addProperty("type", "neoforge:item_exists");
        condition3.addProperty("item", ((WoodcuttingJsonRecipe.ConditionItem)jsonRecipe.conditions[0]).item);
        conditions.add((JsonElement)condition3);
        json.add("neoforge:conditions", (JsonElement)conditions);
        json.addProperty("type", jsonRecipe.type);
        JsonObject ingredient = new JsonObject();
        if (jsonRecipe.ingredient.tag == null) {
            ingredient.addProperty("item", jsonRecipe.ingredient.item);
        } else {
            ingredient.addProperty("tag", jsonRecipe.ingredient.tag);
        }
        json.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("id", jsonRecipe.result);
        result.addProperty("count", (Number)jsonRecipe.count);
        json.add("result", (JsonElement)result);
        return this.toFile(file, json);
    }

    private <T> boolean toFile(File file, JsonObject jsonObject) {
        boolean bl;
        FileWriter fw = new FileWriter(file, StandardCharsets.UTF_8);
        try {
            fw.write(GSON.toJson((JsonElement)jsonObject));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        fw.close();
        return bl;
    }

    private boolean addMcMeta(File datapackFolder, String modid) {
        File file = new File(datapackFolder, "pack.mcmeta");
        if (file.exists()) {
            return true;
        }
        JsonObject json = new JsonObject();
        JsonObject pack = new JsonObject();
        json.add("pack", (JsonElement)pack);
        JsonObject text = new JsonObject();
        text.addProperty("text", "Corail Woodcutter: " + StringUtils.capitalize((String)modid) + " Resources");
        pack.add("description", (JsonElement)text);
        pack.addProperty("pack_format", (Number)48);
        return this.toFile(file, json);
    }

    private Map<String, WoodcuttingJsonRecipe> getJsonRecipes(Collection<RecipeHolder<CraftingRecipe>> recipeHolders, RegistryAccess registryAccess) {
        HashMap<String, WoodcuttingJsonRecipe> jsonRecipes = new HashMap<String, WoodcuttingJsonRecipe>();
        for (RecipeHolder<CraftingRecipe> recipeHolder : recipeHolders) {
            WoodCompo compo;
            ItemStack stack;
            CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
            double weight = this.getWeight((Recipe<CraftingInput>)recipe, registryAccess);
            if (weight == 0.0) continue;
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            NonNullList ingredients = recipe.getIngredients();
            ResourceLocation outputName = Helper.getRegistryRL(result);
            if (ingredients.size() == 1 && this.logs.contains((stack = ((Ingredient)ingredients.getFirst()).getItems()[0]).getItem()) && (compo = this.plankToLog.get(result.getItem())) != null) {
                this.addLogRecipe(jsonRecipes, compo, outputName, result.getCount() / stack.getCount());
                continue;
            }
            WoodCompo compo2 = this.getWoodCompo((NonNullList<Ingredient>)ingredients);
            int count = weight < 1.0 ? Mth.floor((double)(1.0 / weight)) : 1;
            boolean isBamboo = compo2.equals(WoodCompo.BAMBOO);
            if (weight < 3.1) {
                this.addPlankRecipe(jsonRecipes, compo2, outputName, count);
                this.addLogRecipe(jsonRecipes, compo2, outputName, count * (isBamboo ? 2 : 4));
                continue;
            }
            if (isBamboo) continue;
            this.addLogRecipe(jsonRecipes, compo2, outputName, count);
        }
        return jsonRecipes;
    }

    private void addRecipe(Map<String, WoodcuttingJsonRecipe> recipes, ResourceLocation input, ResourceLocation output, int count, boolean isTag) {
        recipes.put(RL_TO_NAME.apply(output) + "_from_" + RL_TO_NAME.apply(input), new WoodcuttingJsonRecipe(input.toString(), output.toString(), count, isTag));
    }

    private void addPlankRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        this.addRecipe(recipes, compo.plankName(), output, count, compo.isPlankTag());
    }

    private void addLogRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        Optional.ofNullable(compo.logName()).ifPresent(logName -> this.addRecipe(recipes, (ResourceLocation)logName, output, count, compo.isLogTag()));
    }

    private double getWeight(Recipe<CraftingInput> recipe, RegistryAccess registryAccess) {
        NonNullList ingredients = recipe.getIngredients();
        double weight = 0.0;
        double maxWeight = 5.0 * (double)recipe.getResultItem((HolderLookup.Provider)registryAccess).getCount();
        for (Ingredient ingredient : ingredients) {
            Predicate<Item> predicate;
            if (ingredient.isEmpty()) continue;
            ItemStack[] stacks = ingredient.getItems();
            ItemStack stack = stacks[0];
            if (stack.is(ItemTags.BAMBOO_BLOCKS)) {
                predicate = item -> Helper.isInTag(item, (TagKey<Item>)ItemTags.BAMBOO_BLOCKS);
                weight += 2.0 * (double)stack.getCount();
            } else if (this.logs.contains(stack.getItem())) {
                predicate = this.logs::contains;
                weight += 4.0 * (double)stack.getCount();
            } else if (this.plankToLog.containsKey(stack.getItem())) {
                predicate = this.plankToLog::containsKey;
                weight += 1.0 * (double)stack.getCount();
            } else if (stack.is(Items.BAMBOO)) {
                predicate = item -> item == Items.BAMBOO;
                weight += 0.25 * (double)stack.getCount();
            } else if (stack.is(Tags.Items.RODS_WOODEN)) {
                predicate = item -> Helper.isInTag(item, (TagKey<Item>)Tags.Items.RODS_WOODEN);
                weight += 0.5 * (double)stack.getCount();
            } else if (stack.is(ItemTags.WOODEN_SLABS)) {
                predicate = item -> Helper.isInTag(item, (TagKey<Item>)ItemTags.WOODEN_SLABS);
                weight += 0.5 * (double)stack.getCount();
            } else {
                return 0.0;
            }
            if (!(weight > maxWeight) && !Arrays.stream(stacks).anyMatch(s -> !predicate.test(s.getItem()))) continue;
            return 0.0;
        }
        return weight / (double)recipe.getResultItem((HolderLookup.Provider)registryAccess).getCount();
    }

    private int testRecipe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        RegistryAccess registryAccess = ((CommandSourceStack)context.getSource()).registryAccess();
        this.initPlanksToLogs(((CommandSourceStack)context.getSource()).getServer(), registryAccess);
        ResourceLocation recipeRL = ResourceLocationArgument.getId(context, (String)RECIPE_PARAM);
        RecipeHolder recipe = ((CommandSourceStack)context.getSource()).getServer().getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().filter(r -> r.id().equals((Object)recipeRL)).findFirst().orElseThrow(() -> LangKey.asStringCommandException(String.format("[ %s ] is not a crafting recipe", recipeRL)));
        Map<String, WoodcuttingJsonRecipe> recipes = this.getJsonRecipes(Collections.singleton(recipe), registryAccess);
        if (recipes.isEmpty()) {
            throw LangKey.asStringCommandException(String.format("[ %s ] is not a wood recipe", recipeRL));
        }
        boolean genericTag = false;
        for (Map.Entry<String, WoodcuttingJsonRecipe> entry : recipes.entrySet()) {
            String ingredient = Optional.ofNullable(entry.getValue().ingredient.tag).orElse(entry.getValue().ingredient.item);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("name=" + (String)entry.getKey())).append("\n").append("ingredient=" + ingredient + " (" + (((WoodcuttingJsonRecipe)entry.getValue()).ingredient.tag == null ? "item" : "tag") + ")").append("\n").append("result=" + ((WoodcuttingJsonRecipe)entry.getValue()).result + "*" + ((WoodcuttingJsonRecipe)entry.getValue()).count), false);
            if (entry.getValue().ingredient.tag == null || !ingredient.equals("minecraft:logs") && !ingredient.equals("minecraft:planks")) continue;
            genericTag = true;
        }
        MutableComponent successText = Component.literal((String)(genericTag ? "check this recipe as it uses a generic tag that may be incorrect" : "[" + String.valueOf(recipeRL) + "] is a valid recipe"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandWoodcutter.lambda$testRecipe$36((Component)successText), false);
        return 1;
    }

    private void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"woodcutter").requires(this::hasPermission)).executes(this::showUsage)).then(BaseAction.INFO.literal().executes(this::showUsage))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BaseAction.DATAPACK.literal().executes(this::showUsage)).then(((LiteralArgumentBuilder)DataPackAction.GENERATE.literal().executes(this::showUsage)).then(Commands.argument((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::generateDataPack)))).then(((LiteralArgumentBuilder)DataPackAction.APPLY.literal().executes(this::showUsage)).then(Commands.argument((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::applyDataPack)))).then(((LiteralArgumentBuilder)DataPackAction.REMOVE.literal().executes(this::showUsage)).then(Commands.argument((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::removeDataPack))))).then(((LiteralArgumentBuilder)BaseAction.TEST.literal().executes(this::showUsage)).then(Commands.argument((String)RECIPE_PARAM, (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGESTION_CRAFTING_RECIPES).executes(this::testRecipe))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cwc").requires(this::hasPermission)).redirect((CommandNode)command));
    }

    private boolean hasPermission(CommandSourceStack source) {
        return source.hasPermission(2) || this.isSinglePlayerOwner(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSinglePlayerOwner(CommandSourceStack source) {
        if (source.getServer().isDedicatedServer()) return false;
        if (!source.getServer().isSingleplayer()) return false;
        if (Optional.ofNullable(source.getEntity()).filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).map(Player::getGameProfile).map(profil -> source.getServer().isSingleplayerOwner(profil)).orElse(false) == false) return false;
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        new CommandWoodcutter().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static /* synthetic */ Component lambda$testRecipe$36(Component successText) {
        return successText;
    }

    private record WoodCompo(ResourceLocation plankName, boolean isPlankTag, @Nullable ResourceLocation logName, boolean isLogTag) {
        private static final WoodCompo ANY_WOOD = new WoodCompo(ItemTags.PLANKS.location(), true, ItemTags.LOGS.location(), true);
        private static final WoodCompo BAMBOO = WoodCompo.of(Items.BAMBOO_PLANKS, (TagKey<Item>)ItemTags.BAMBOO_BLOCKS);

        public static WoodCompo of(Item item, TagKey<Item> tagKey) {
            return WoodCompo.of(item, tagKey.location(), true);
        }

        public static WoodCompo of(Item item, @Nullable ResourceLocation logName, boolean isLogTag) {
            return new WoodCompo(Helper.getRegistryRL(item), false, logName, isLogTag);
        }
    }

    private static enum BaseAction implements IAction
    {
        INFO,
        DATAPACK,
        TEST;

        private final String name = this.name().toLowerCase(Locale.US);

        public String getSerializedName() {
            return this.name;
        }
    }

    private static enum DataPackAction implements IAction
    {
        GENERATE,
        APPLY,
        REMOVE;

        private final String name = this.name().toLowerCase(Locale.US);

        public String getSerializedName() {
            return this.name;
        }
    }

    private static interface IAction
    extends StringRepresentable {
        default public LiteralArgumentBuilder<CommandSourceStack> literal() {
            return Commands.literal((String)this.getSerializedName());
        }
    }
}

