/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.data.v2.core.RegistriesDataProvider;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.core.NeoForgeDataProviderContext;
import fuzs.puzzleslib.neoforge.impl.data.FileHelperDataProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class DataProviderHelper {
    private DataProviderHelper() {
    }

    public static void registerDataProviders(String modId, NeoForgeDataProviderContext.Factory ... factories) {
        DataProviderHelper.registerDataProviders(modId, factories, factory -> (evt, registries) -> (DataProvider)factory.apply(NeoForgeDataProviderContext.fromEvent(modId, evt, registries)));
    }

    public static void registerDataProviders(String modId, NeoForgeDataProviderContext.LegacyFactory ... factories) {
        DataProviderHelper.registerDataProviders(modId, factories, factory -> (evt, registries) -> (DataProvider)factory.apply(evt, modId));
    }

    static <T> void registerDataProviders(String modId, T[] factories, Function<T, Factory> factoryConverter) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        Preconditions.checkState((factories.length > 0 ? 1 : 0) != 0, (Object)"data provider factories is empty");
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(evt -> DataProviderHelper.onGatherData(evt, Arrays.stream(factories).map(factoryConverter).toList())));
    }

    static void onGatherData(GatherDataEvent evt, Collection<Factory> factories) {
        CompletableFuture<HolderLookup.Provider> registries = evt.getLookupProvider();
        for (Factory factory : factories) {
            DataProvider dataProvider = (DataProvider)factory.apply(evt, registries);
            if (dataProvider instanceof RegistriesDataProvider) {
                RegistriesDataProvider registriesDataProvider = (RegistriesDataProvider)dataProvider;
                registries = registriesDataProvider.getRegistries();
            }
            if (dataProvider instanceof FileHelperDataProvider) {
                FileHelperDataProvider fileHelperDataProvider = (FileHelperDataProvider)dataProvider;
                fileHelperDataProvider.puzzleslib$setExistingFileHelper(evt.getExistingFileHelper());
            }
            evt.getGenerator().addProvider(true, dataProvider);
        }
    }

    @FunctionalInterface
    static interface Factory
    extends BiFunction<GatherDataEvent, CompletableFuture<HolderLookup.Provider>, DataProvider> {
    }
}

