/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.key.v1;

import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.impl.client.key.KeyActivationHandlerImpl;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface KeyActivationHandler {
    public static KeyActivationHandler direct(KeyActivationContext activationContext) {
        return () -> activationContext;
    }

    public static KeyActivationHandler of() {
        return new KeyActivationHandlerImpl(null, null, null);
    }

    public static KeyActivationHandler forGame(Consumer<Minecraft> gameHandler) {
        Objects.requireNonNull(gameHandler, "game handler is null");
        return new KeyActivationHandlerImpl(gameHandler, null, null);
    }

    public static KeyActivationHandler forScreen(Consumer<Screen> screenHandler) {
        return KeyActivationHandler.forScreen(Screen.class, screenHandler);
    }

    public static <T extends Screen> KeyActivationHandler forScreen(Class<T> screenType, Consumer<T> screenHandler) {
        Objects.requireNonNull(screenType, "screen type is null");
        Objects.requireNonNull(screenHandler, "screen handler is null");
        return new KeyActivationHandlerImpl(null, screenType, screenHandler);
    }

    public KeyActivationContext getActivationContext();

    @Nullable
    default public Consumer<Minecraft> gameHandler() {
        return null;
    }

    @Nullable
    default public Class<? extends Screen> screenType() {
        return null;
    }

    @Nullable
    default public Consumer<? extends Screen> screenHandler() {
        return null;
    }

    default public KeyActivationHandler withGameHandler(Consumer<Minecraft> gameHandler) {
        return this;
    }

    default public KeyActivationHandler withScreenHandler(Consumer<Screen> screenHandler) {
        return this.withScreenHandler(Screen.class, screenHandler);
    }

    default public <T extends Screen> KeyActivationHandler withScreenHandler(Class<T> screenType, Consumer<T> screenHandler) {
        return this;
    }
}

