/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IAttackTargetChanger;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IMobEntityChanger;
import de.cech12.usefulhats.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HaloItem
extends AbstractHatItem
implements IAttackTargetChanger,
IMobEntityChanger,
IEquipmentChangeListener {
    private static final Map<LivingEntity, Integer> PREVIOUS_DAMAGE_TICK_OF_ENTITY = new HashMap<LivingEntity, Integer>();

    public HaloItem() {
        super(HatArmorMaterials.HALO, HaloItem.rawColorFromRGB(255, 236, 142), Services.CONFIG::getHaloDurability, Services.CONFIG::isHaloDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.halo.desc.no_attack").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.halo.desc.beware_of_nether").withStyle(ChatFormatting.RED));
    }

    private static boolean isEntityInNether(Entity entity) {
        return entity.level().dimensionType().respawnAnchorWorks();
    }

    @Override
    public void onEntityJoinWorldEvent(LivingEntity entity) {
        if (entity instanceof ZombifiedPiglin) {
            ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)entity;
            Services.REGISTRY.addGoalToMob((Mob)zombifiedPiglin, 1, (Goal)new NearestHaloTargetGoal((Mob)zombifiedPiglin, this));
        }
    }

    @Override
    public boolean avoidMobChangingTarget(ItemStack stack, LivingEntity entity, LivingEntity target) {
        Integer previousDamageTick;
        if (Services.REGISTRY.isBossEntity(entity) || HaloItem.isEntityInNether((Entity)target)) {
            return false;
        }
        if (((Boolean)this.enabledDamageConfig.get()).booleanValue() && ((previousDamageTick = PREVIOUS_DAMAGE_TICK_OF_ENTITY.get(target)) == null || previousDamageTick + 20 <= target.tickCount)) {
            this.damageHatItemByOne(stack, target);
            PREVIOUS_DAMAGE_TICK_OF_ENTITY.put(target, target.tickCount);
        }
        return true;
    }

    @Override
    public void onEquippedHatItem(LivingEntity entity, ItemStack newStack) {
        if (HaloItem.isEntityInNether((Entity)entity)) {
            return;
        }
        Vec3 entityPos = entity.position();
        int range = 32;
        AABB radius = new AABB(entityPos.x() - (double)range, entityPos.y() - (double)range, entityPos.z() - (double)range, entityPos.x() + (double)range, entityPos.y() + (double)range, entityPos.z() + (double)range);
        entity.level().getEntitiesOfClass(Mob.class, radius, mob -> mob.getTarget() == entity && !Services.REGISTRY.isBossEntity((LivingEntity)mob)).forEach(mob -> mob.setTarget(null));
    }

    private static class NearestHaloTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        NearestHaloTargetGoal(Mob mobEntity, IMobEntityChanger hatItem) {
            super(mobEntity, LivingEntity.class, 0, true, false, entity -> {
                if (entity instanceof LivingEntity && HaloItem.isEntityInNether((Entity)entity)) {
                    for (ItemStack headSlotItemStack : Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)entity)) {
                        if (headSlotItemStack.getItem() != hatItem) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }
}

