/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.client.AbstractUsefulHatsRenderer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHatItem
extends ArmorItem {
    private final int initColor;
    private final Supplier<Integer> durabilityConfig;
    protected final Supplier<Boolean> enabledDamageConfig;

    public AbstractHatItem(Holder<ArmorMaterial> material, int initColor, Supplier<Integer> durabilityConfig, Supplier<Boolean> enabledDamageConfig) {
        super(material, ArmorItem.Type.HELMET, new Item.Properties());
        this.initColor = initColor;
        this.durabilityConfig = durabilityConfig;
        this.enabledDamageConfig = enabledDamageConfig;
    }

    protected static int rawColorFromRGB(int red, int green, int blue) {
        return FastColor.ARGB32.color((int)red, (int)green, (int)blue);
    }

    public int getDurabilityFromConfig() {
        return this.durabilityConfig.get();
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    protected boolean isEffectCausedByOtherSource(LivingEntity entity, Holder<MobEffect> effect, int maxDuration, int amplifier) {
        MobEffectInstance effectInstance = entity.getEffect(effect);
        return effectInstance != null && (effectInstance.isAmbient() || effectInstance.getDuration() >= maxDuration || effectInstance.getAmplifier() != amplifier);
    }

    protected void addEffect(LivingEntity entity, Holder<MobEffect> effect, int duration, int amplifier) {
        this.addEffect(entity, effect, duration, amplifier, false);
    }

    protected void addEffect(LivingEntity entity, Holder<MobEffect> effect, int duration, int amplifier, boolean showParticles) {
        entity.addEffect(new MobEffectInstance(effect, duration, amplifier, false, showParticles, true));
    }

    protected void removeEffect(LivingEntity entity, Holder<MobEffect> effect, int maxDuration, int amplifier) {
        MobEffectInstance effectInstance = entity.getEffect(effect);
        if (effectInstance != null && !effectInstance.isAmbient() && effectInstance.getDuration() <= maxDuration && effectInstance.getAmplifier() == amplifier) {
            entity.removeEffect(effect);
        }
    }

    protected void damageHatItemByOne(ItemStack stack, LivingEntity entity) {
        block5: {
            ServerLevel serverLevel;
            block6: {
                Level level;
                if (!this.enabledDamageConfig.get().booleanValue()) {
                    return;
                }
                if (entity.level().isClientSide || !((level = entity.level()) instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (!(entity instanceof ServerPlayer)) break block6;
                ServerPlayer player = (ServerPlayer)entity;
                if (player.getAbilities().instabuild) break block5;
            }
            if (stack.isDamageableItem()) {
                stack.hurtAndBreak(1, serverLevel, entity instanceof ServerPlayer ? (ServerPlayer)entity : null, item -> {
                    entity.onEquippedItemBroken(item, EquipmentSlot.HEAD);
                    stack.shrink(1);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.awardStat(Stats.ITEM_BROKEN.get((Object)this));
                    }
                    stack.setDamageValue(0);
                });
            }
        }
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return ItemAttributeModifiers.EMPTY;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)("item.modifiers." + EquipmentSlot.HEAD.getName())).withStyle(ChatFormatting.GRAY));
    }

    public int getDefaultColor() {
        return this.initColor;
    }

    public boolean hasChristmasVariant() {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getDurabilityFromConfig();
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean inner) {
        return AbstractUsefulHatsRenderer.getArmorTexture((ArmorItem)stack.getItem(), layer);
    }
}

