/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.dumplings_delight.block;

import cn.foggyhillside.dumplings_delight.registry.DumplingsDelightEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DumplingMedleyBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)7);
    public final boolean hasLeftovers;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)};

    public DumplingMedleyBlock(BlockBehaviour.Properties properties, boolean hasLeftovers) {
        super(properties);
        this.hasLeftovers = hasLeftovers;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(this.getMaxServings())));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 7;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)SERVINGS)];
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide && this.takeServing((LevelAccessor)level, pos, state, player, hand).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.takeServing((LevelAccessor)level, pos, state, player, hand);
    }

    protected ItemInteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings == 0) {
            level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.destroyBlock(pos, true);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.isEmpty() && player.canEat(false)) {
            if (servings == 7 || servings == 6) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 50, 0));
                if (!player.getAbilities().instabuild) {
                    if (this.hasGarlicEffect(player)) {
                        player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() + 6);
                    } else {
                        player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() + 5);
                    }
                    player.getFoodData().setSaturation(player.getFoodData().getSaturationLevel() + 7.0f);
                }
                level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (servings == 5 || servings == 4 || servings == 3) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 50, 0));
                if (!player.getAbilities().instabuild) {
                    if (this.hasGarlicEffect(player)) {
                        player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() + 7);
                    } else {
                        player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() + 6);
                    }
                    player.getFoodData().setSaturation(player.getFoodData().getSaturationLevel() + 7.0f);
                }
                level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (servings == 2 || servings == 1) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 50, 0));
                if (!player.getAbilities().instabuild) {
                    if (this.hasGarlicEffect(player)) {
                        player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() + 9);
                    } else {
                        player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() + 8);
                    }
                    player.getFoodData().setSaturation(player.getFoodData().getSaturationLevel() + 7.0f);
                }
                level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean hasGarlicEffect(Player player) {
        return player.hasEffect(DumplingsDelightEffects.GARLIC);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SERVINGS});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.getValue((Property)this.getServingsProperty());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

