/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.SecureJar;
import java.io.Closeable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface JarContents
extends Closeable {
    public Path getPrimaryPath();

    public Optional<URI> findFile(String var1);

    public Manifest getManifest();

    public Set<String> getPackages();

    public Set<String> getPackagesExcluding(String ... var1);

    public List<SecureJar.Provider> getMetaInfServices();

    public static JarContents of(Path fileOrFolder) {
        return new JarContentsBuilder().paths(fileOrFolder).build();
    }

    public static JarContents of(Collection<Path> filesOrFolders) {
        return new JarContentsBuilder().paths(filesOrFolders.toArray(new Path[0])).build();
    }
}

