/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JarModuleFinder
implements ModuleFinder {
    private final Map<String, ModuleReference> moduleReferenceMap;

    JarModuleFinder(SecureJar ... jars) {
        this.moduleReferenceMap = ((Stream)Arrays.stream(jars).parallel()).collect(Collectors.toMap(jar -> jar.moduleDataProvider().name(), jar -> new JarModuleReference(jar.moduleDataProvider()), (r1, r2) -> r1));
    }

    @Override
    public Optional<ModuleReference> find(String name) {
        return Optional.ofNullable(this.moduleReferenceMap.get(name));
    }

    @Override
    public Set<ModuleReference> findAll() {
        return new HashSet<ModuleReference>(this.moduleReferenceMap.values());
    }

    public static JarModuleFinder of(SecureJar ... jars) {
        return new JarModuleFinder(jars);
    }

    static class JarModuleReference
    extends ModuleReference {
        private final SecureJar.ModuleDataProvider jar;

        JarModuleReference(SecureJar.ModuleDataProvider jar) {
            super(jar.descriptor(), jar.uri());
            this.jar = jar;
        }

        @Override
        public ModuleReader open() throws IOException {
            return new JarModuleReader(this.jar);
        }

        public SecureJar.ModuleDataProvider jar() {
            return this.jar;
        }
    }

    static class JarModuleReader
    implements ModuleReader {
        private final SecureJar.ModuleDataProvider jar;

        public JarModuleReader(SecureJar.ModuleDataProvider jar) {
            this.jar = jar;
        }

        @Override
        public Optional<URI> find(String name) throws IOException {
            return this.jar.findFile(name);
        }

        @Override
        public Optional<InputStream> open(String name) throws IOException {
            return this.jar.open(name);
        }

        @Override
        public Stream<String> list() throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.getClass().getName() + "[jar=" + String.valueOf(this.jar) + "]";
        }
    }
}

