/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling;

import de.maxhenkel.tradecycling.TradeCyclingClientMod;
import de.maxhenkel.tradecycling.config.NeoForgeTradeCyclingClientConfig;
import de.maxhenkel.tradecycling.config.TradeCyclingClientConfig;
import de.maxhenkel.tradecycling.net.CycleTradesPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgeTradeCyclingClientMod
extends TradeCyclingClientMod {
    public NeoForgeTradeCyclingClientMod(IEventBus eventBus) {
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::onRegisterKeyBinds);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.clientInit();
    }

    @Override
    public void clientInit() {
        super.clientInit();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void sendCycleTradesPacket() {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CycleTradesPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        event.register(CYCLE_TRADES_KEY);
    }

    @Override
    public TradeCyclingClientConfig createClientConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        NeoForgeTradeCyclingClientConfig config = new NeoForgeTradeCyclingClientConfig(builder);
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById("trade_cycling").orElseThrow(() -> new RuntimeException("Could not find mod %s".formatted("trade_cycling")));
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build());
        return config;
    }

    @SubscribeEvent
    public void onInitScreen(ScreenEvent.Init.Post event) {
        this.onOpenScreen(event.getScreen(), x$0 -> event.addListener((GuiEventListener)x$0));
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        this.onCycleKeyPressed(event.getKey(), event.getScanCode(), event.getAction());
    }
}

