/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public class TagEntry {
    private static final Codec<TagEntry> FULL_CODEC = RecordCodecBuilder.create(p_215937_ -> p_215937_.group((App)ExtraCodecs.TAG_OR_ELEMENT_ID.fieldOf("id").forGetter(TagEntry::elementOrTag), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(p_215952_ -> p_215952_.required)).apply((Applicative)p_215937_, TagEntry::new));
    public static final Codec<TagEntry> CODEC = Codec.either((Codec)ExtraCodecs.TAG_OR_ELEMENT_ID, FULL_CODEC).xmap(p_215935_ -> (TagEntry)p_215935_.map(p_215933_ -> new TagEntry((ExtraCodecs.TagOrElementLocation)p_215933_, true), p_215946_ -> p_215946_), p_215931_ -> p_215931_.required ? Either.left((Object)p_215931_.elementOrTag()) : Either.right((Object)p_215931_));
    private final ResourceLocation id;
    private final boolean tag;
    private final boolean required;

    private TagEntry(ResourceLocation p_215918_, boolean p_215919_, boolean p_215920_) {
        this.id = p_215918_;
        this.tag = p_215919_;
        this.required = p_215920_;
    }

    private TagEntry(ExtraCodecs.TagOrElementLocation p_215922_, boolean p_215923_) {
        this.id = p_215922_.id();
        this.tag = p_215922_.tag();
        this.required = p_215923_;
    }

    private ExtraCodecs.TagOrElementLocation elementOrTag() {
        return new ExtraCodecs.TagOrElementLocation(this.id, this.tag);
    }

    TagEntry withRequired(boolean required) {
        return new TagEntry(this.id, this.tag, required);
    }

    public static TagEntry element(ResourceLocation p_215926_) {
        return new TagEntry(p_215926_, false, true);
    }

    public static TagEntry optionalElement(ResourceLocation p_215944_) {
        return new TagEntry(p_215944_, false, false);
    }

    public static TagEntry tag(ResourceLocation p_215950_) {
        return new TagEntry(p_215950_, true, true);
    }

    public static TagEntry optionalTag(ResourceLocation p_215954_) {
        return new TagEntry(p_215954_, true, false);
    }

    public <T> boolean build(Lookup<T> p_215928_, Consumer<T> p_215929_) {
        if (this.tag) {
            Collection<T> collection = p_215928_.tag(this.id);
            if (collection == null) {
                return !this.required;
            }
            collection.forEach(p_215929_);
        } else {
            T t = p_215928_.element(this.id);
            if (t == null) {
                return !this.required;
            }
            p_215929_.accept(t);
        }
        return true;
    }

    public void visitRequiredDependencies(Consumer<ResourceLocation> p_215939_) {
        if (this.tag && this.required) {
            p_215939_.accept(this.id);
        }
    }

    public void visitOptionalDependencies(Consumer<ResourceLocation> p_215948_) {
        if (this.tag && !this.required) {
            p_215948_.accept(this.id);
        }
    }

    public boolean verifyIfPresent(Predicate<ResourceLocation> p_215941_, Predicate<ResourceLocation> p_215942_) {
        return !this.required || (this.tag ? p_215942_ : p_215941_).test(this.id);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        if (this.tag) {
            stringbuilder.append('#');
        }
        stringbuilder.append(this.id);
        if (!this.required) {
            stringbuilder.append('?');
        }
        return stringbuilder.toString();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isTag() {
        return this.tag;
    }

    public static interface Lookup<T> {
        @Nullable
        public T element(ResourceLocation var1);

        public Collection<T> tag(ResourceLocation var1);
    }
}

