/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class EntityUtils {
    public static void moveTowardsPosition(Entity entity, Vec3 targetPos, double speed) {
        Vec3 motion = targetPos.subtract(entity.position()).normalize().scale(speed);
        entity.setDeltaMovement(motion.x, motion.y, motion.z);
    }

    public static int getSlotWithItem(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (player.getInventory().getItem(i).getItem() != item) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getSlotsWithItem(Player player, Item item) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (player.getInventory().getItem(i).getItem() != item) continue;
            list.add(i);
            if (i != player.getInventory().getContainerSize()) continue;
            return list;
        }
        return list;
    }

    public static void addItem(Player player, ItemStack stack) {
        if (player.addItem(stack)) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        RandomSource random = level.getRandom();
        ItemEntity drop = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stack);
        drop.setDeltaMovement((double)(MathUtils.randomFloat(random) * 0.15f), (double)(0.1f + random.nextFloat() * 0.2f), (double)(MathUtils.randomFloat(random) * 0.15f));
        drop.setPickUpDelay(20);
        level.addFreshEntity((Entity)drop);
    }

    public static EntityHitResult rayTraceEntity(Entity shooter, Predicate<? super Entity> filter, double distance) {
        Level world = shooter.level();
        Vec3 startVec = shooter.getEyePosition(1.0f);
        Vec3 endVec = shooter.getEyePosition(1.0f).add(shooter.getViewVector(1.0f).scale(distance));
        double d0 = distance * distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.getEntities(shooter, shooter.getBoundingBox().expandTowards(shooter.getViewVector(1.0f).scale(distance * distance)).inflate(1.0), filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optional = axisalignedbb.clip(startVec, endVec);
            if (axisalignedbb.contains(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.distanceToSqr(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.getRootVehicle() == shooter.getRootVehicle() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    private static ResourceLocation getAttributeId(ItemStack stack, Attribute attribute) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + "_" + BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute).getPath()));
    }

    public static void applyAttribute(LivingEntity entity, ItemStack stack, Holder<Attribute> attributeHolder, float value, AttributeModifier.Operation operation) {
        Attribute attribute = (Attribute)attributeHolder.value();
        ResourceLocation id = EntityUtils.getAttributeId(stack, attribute);
        AttributeInstance instance = entity.getAttribute(attributeHolder);
        if (instance == null || instance.hasModifier(id)) {
            return;
        }
        instance.addTransientModifier(new AttributeModifier(id, (double)value, operation));
    }

    public static void removeAttribute(LivingEntity entity, ItemStack stack, Holder<Attribute> attributeHolder, AttributeModifier.Operation operation) {
        Attribute attribute = (Attribute)attributeHolder.value();
        ResourceLocation id = EntityUtils.getAttributeId(stack, attribute);
        AttributeInstance instance = entity.getAttribute(attributeHolder);
        if (instance == null) {
            return;
        }
        if (!instance.hasModifier(id)) {
            return;
        }
        instance.removeModifier(new AttributeModifier(id, instance.getValue(), operation));
    }

    public static void resetAttribute(LivingEntity entity, ItemStack stack, Holder<Attribute> attributeHolder, float value, AttributeModifier.Operation operation) {
        EntityUtils.removeAttribute(entity, stack, attributeHolder, operation);
        EntityUtils.applyAttribute(entity, stack, attributeHolder, value, operation);
    }

    public static ItemStack findEquippedCurio(Entity entity, Item item) {
        if (!(entity instanceof Player)) {
            return ItemStack.EMPTY;
        }
        Player player = (Player)entity;
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player);
        if (optional.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)((ImmutableTriple)optional.get()).getRight();
    }

    public static List<ItemStack> findEquippedCurios(Entity entity, Item item) {
        if (!(entity instanceof Player)) {
            return List.of();
        }
        Player player = (Player)entity;
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.findCurios(item).stream().map(SlotResult::stack).toList()).orElse(List.of());
    }

    public static long getExperienceForLevel(int level) {
        return level >= 30 ? 112L + (long)(level - 30) * 9L : (level >= 15 ? (long)(37 + (level - 15) * 5) : 7L + (long)level * 2L);
    }

    public static long getTotalExperienceForLevel(int level) {
        long result = 0L;
        for (int i = 0; i < level; ++i) {
            result += EntityUtils.getExperienceForLevel(i);
        }
        return result;
    }

    public static long getPlayerTotalExperience(Player player) {
        long totalExperience = 0L;
        for (int level = 0; level < player.experienceLevel; ++level) {
            totalExperience += EntityUtils.getExperienceForLevel(level);
        }
        return totalExperience += (long)Math.round(player.experienceProgress * (float)EntityUtils.getExperienceForLevel(player.experienceLevel));
    }

    public static double getLevelFromTotalExperience(long totalXP) {
        if (totalXP <= 0L) {
            return 0.0;
        }
        if (totalXP < 315L) {
            double calculatedLevel = (-6.0 + Math.sqrt(36L + 4L * totalXP)) / 2.0;
            int floorLevel = (int)Math.floor(calculatedLevel);
            double xpAtLevel = floorLevel * floorLevel + 6 * floorLevel;
            double xpNeededForNextLevel = 7 + 2 * floorLevel;
            double progressWithinLevel = ((double)totalXP - xpAtLevel) / xpNeededForNextLevel;
            return MathUtils.round((double)floorLevel + progressWithinLevel, 1);
        }
        if (totalXP < 1395L) {
            double xpOffset = totalXP - 315L;
            double discriminant = 1190.25 + 10.0 * xpOffset;
            double levelOffset = (-34.5 + Math.sqrt(discriminant)) / 5.0;
            double calculatedLevel = 15.0 + levelOffset;
            int floorLevel = (int)Math.floor(calculatedLevel);
            int offsetInt = floorLevel - 15;
            long xpAtLevel = 315L + 37L * (long)offsetInt + (long)((int)(2.5 * (double)offsetInt * (double)(offsetInt - 1)));
            long xpNeededForNextLevel = 37L + 5L * (long)offsetInt;
            double progressWithinLevel = (double)(totalXP - xpAtLevel) / (double)xpNeededForNextLevel;
            return MathUtils.round((double)floorLevel + progressWithinLevel, 1);
        }
        double xpOffset = totalXP - 1395L;
        double levelOffset = (-107.5 + Math.sqrt(11556.25 + 18.0 * xpOffset)) / 9.0;
        double calculatedLevel = 30.0 + levelOffset;
        int floorLevel = (int)Math.floor(calculatedLevel);
        int offsetInt = floorLevel - 30;
        long xpAtLevel = 1395L + 112L * (long)offsetInt + (long)(4.5 * (double)offsetInt * (double)(offsetInt - 1));
        long xpNeededForNextLevel = 112L + 9L * (long)offsetInt;
        double progressWithinLevel = (double)(totalXP - xpAtLevel) / (double)xpNeededForNextLevel;
        return MathUtils.round((double)floorLevel + progressWithinLevel, 1);
    }

    public static double calculateExperienceLevelLoss(Player player, long experience) {
        long totalExperience = EntityUtils.getPlayerTotalExperience(player);
        long targetTotalExperience = Math.max(0L, totalExperience - experience);
        double currentLevel = EntityUtils.getLevelFromTotalExperience(totalExperience);
        double newLevel = EntityUtils.getLevelFromTotalExperience(targetTotalExperience);
        return MathUtils.round(currentLevel - newLevel, 1);
    }

    public static boolean isAlliedTo(@Nullable Entity source, @Nullable Entity target) {
        OwnableEntity ownableSource;
        OwnableEntity ownableTarget;
        return source == null || target == null || source.isAlliedTo(target) || target.isAlliedTo(source) || target.getUUID().equals(source.getUUID()) || target instanceof OwnableEntity && (ownableTarget = (OwnableEntity)target).getOwnerUUID() != null && ownableTarget.getOwnerUUID().equals(source.getUUID()) || source instanceof OwnableEntity && (ownableSource = (OwnableEntity)source).getOwnerUUID() != null && ownableSource.getOwnerUUID().equals(target.getUUID());
    }

    public static boolean hurt(LivingEntity entity, DamageSource source, float amount) {
        LivingEntity sourceEntity;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity && EntityUtils.isAlliedTo((Entity)(sourceEntity = (LivingEntity)entity2), (Entity)entity)) {
            return false;
        }
        return entity.hurt(source, amount);
    }

    public static List<ItemStack> getEquippedRelics(LivingEntity entity) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (!(entity instanceof Player)) {
            return items;
        }
        Player player = (Player)entity;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof IRelicItem)) continue;
            items.add(stack);
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            for (int i = 0; i < handler.getEquippedCurios().getSlots(); ++i) {
                ItemStack stack = handler.getEquippedCurios().getStackInSlot(i);
                if (!(stack.getItem() instanceof IRelicItem)) continue;
                items.add(stack);
            }
        });
        return items;
    }

    public static <T extends LivingEntity> Stream<T> gatherPotentialTargets(Entity seeker, Class<T> type, double radius) {
        return seeker.getCommandSenderWorld().getEntitiesOfClass(type, seeker.getBoundingBox().inflate(radius)).stream().sorted(Comparator.comparing(entry -> seeker.position().distanceTo(entry.position()))).filter(entry -> !(entry instanceof ArmorStand) && !entry.isDeadOrDying() && entry.hasLineOfSight(seeker) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entry));
    }
}

