/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.lock;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketAbilityUnlock
implements CustomPacketPayload {
    private final int container;
    private final int slot;
    private final String ability;
    private final int unlocks;
    public static final CustomPacketPayload.Type<PacketAbilityUnlock> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"ability_unlock"));
    public static final StreamCodec<ByteBuf, PacketAbilityUnlock> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketAbilityUnlock::getContainer, (StreamCodec)ByteBufCodecs.INT, PacketAbilityUnlock::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketAbilityUnlock::getAbility, (StreamCodec)ByteBufCodecs.INT, PacketAbilityUnlock::getUnlocks, PacketAbilityUnlock::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player.containerMenu.containerId != this.container) {
                PacketAbilityUnlock.causeError(player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack(player, this.slot);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                PacketAbilityUnlock.causeError(player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            relic.setLockUnlocks(stack, this.ability, this.unlocks);
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketAbilityUnlock.causeError(player);
            }
        });
    }

    private static void causeError(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"info.relics.researching.wrong_container").withStyle(ChatFormatting.RED), false);
        player.closeContainer();
    }

    public int getContainer() {
        return this.container;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getAbility() {
        return this.ability;
    }

    public int getUnlocks() {
        return this.unlocks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketAbilityUnlock)) {
            return false;
        }
        PacketAbilityUnlock other = (PacketAbilityUnlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getUnlocks() != other.getUnlocks()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        return !(this$ability == null ? other$ability != null : !this$ability.equals(other$ability));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketAbilityUnlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getUnlocks();
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        return result;
    }

    public String toString() {
        return "PacketAbilityUnlock(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", unlocks=" + this.getUnlocks() + ")";
    }

    public PacketAbilityUnlock(int container, int slot, String ability, int unlocks) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.unlocks = unlocks;
    }
}

