/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.badges.base.AbilityBadge;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.base.ITabbedDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.AbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.BigAbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.PageWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.RerollAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.ResetAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.UpgradeAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.experience.ExperienceDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.misc.DescriptionTab;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.AbilityBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LogoWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LuckPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PlayerExperiencePlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsFixWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.TabWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionCache;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.RelicExperienceWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.init.BadgeRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen
implements IAutoScaledScreen,
IRelicScreenProvider,
ITabbedDescriptionScreen {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;
    private int page;
    private final int backgroundHeight = 256;
    private final int backgroundWidth = 418;
    public UpgradeAbilityActionWidget upgradeButton;
    public RerollAbilityActionWidget rerollButton;
    public ResetAbilityActionWidget resetButton;

    public AbilityDescriptionScreen(Player player, int container, int slot, Screen screen) {
        super((Component)Component.empty());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
        Item item = this.stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            List<String> abilities = relic.getAbilitiesData().getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled(this.stack, (String)entry)).toList();
            this.setPage(abilities.indexOf(this.getSelectedAbility()) / 5);
        }
    }

    public String getSelectedAbility() {
        return DescriptionCache.getSelectedAbility(this.stack);
    }

    public void setSelectedAbility(String ability) {
        DescriptionCache.setSelectedAbility(this.stack, ability);
    }

    protected void init() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        String ability = this.getSelectedAbility();
        if (relic.getAbilityData(ability) == null) {
            return;
        }
        this.updateCache(relic);
        int x = (this.width - 418) / 2;
        int y = (this.height - 256) / 2;
        Map<String, LevelingSourceData> sources = relic.getLevelingSourcesData().getSources();
        List<String> abilities = relic.getAbilitiesData().getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled(this.stack, (String)entry)).toList();
        int maxEntries = 5;
        if (abilities.size() > maxEntries) {
            this.addRenderableWidget((GuiEventListener)new PageWidget(x + 289, y + 151, this, 1));
            this.addRenderableWidget((GuiEventListener)new PageWidget(x + 289, y + 186, this, -1));
        }
        int startIndex = this.page * maxEntries;
        int endIndex = Math.min(startIndex + maxEntries, abilities.size());
        ArrayList paginatedAbilities = startIndex < abilities.size() && startIndex >= 0 ? abilities.subList(startIndex, endIndex) : new ArrayList();
        this.addRenderableWidget((GuiEventListener)new TabWidget(x + 81, y + 123, this, DescriptionTab.RELIC, new RelicDescriptionScreen((Player)this.minecraft.player, this.container, this.slot, this.screen)));
        int xOff = 19;
        if (!paginatedAbilities.isEmpty()) {
            this.addRenderableWidget((GuiEventListener)new TabWidget(x + 81 + xOff, y + 123, this, DescriptionTab.ABILITY, new AbilityDescriptionScreen((Player)this.minecraft.player, this.container, this.slot, this.screen)));
            xOff += 19;
        }
        if (!sources.isEmpty()) {
            this.addRenderableWidget((GuiEventListener)new TabWidget(x + 81 + xOff, y + 123, this, DescriptionTab.EXPERIENCE, new ExperienceDescriptionScreen((Player)this.minecraft.player, this.container, this.slot, this.screen)));
        }
        this.addRenderableWidget((GuiEventListener)new BigAbilityCardWidget(x + 60, y + 47, this));
        this.addRenderableWidget((GuiEventListener)new LogoWidget(x + 313, y + 57, this));
        if (relic.isSomethingWrongWithLevelingPoints(this.stack)) {
            this.addRenderableWidget((GuiEventListener)new PointsFixWidget(x + 330, y + 33, this));
        }
        this.addRenderableWidget((GuiEventListener)new PointsPlateWidget(x + 313, y + 77, this));
        this.addRenderableWidget((GuiEventListener)new PlayerExperiencePlateWidget(x + 313, y + 102, this));
        this.addRenderableWidget((GuiEventListener)new LuckPlateWidget(x + 313, y + 127, this));
        xOff = 0;
        if (relic.isAbilityUnlocked(this.stack, ability)) {
            for (AbilityBadge badge : BadgeRegistry.BADGES.getEntries().stream().map(DeferredHolder::get).filter(entry -> entry instanceof AbilityBadge).map(entry -> (AbilityBadge)entry).toList()) {
                if (!badge.isVisible(this.stack, ability)) continue;
                this.addRenderableWidget((GuiEventListener)new AbilityBadgeWidget(x + 270 - xOff, y + 63, this, badge, ability));
                xOff += 15;
            }
        }
        if (!paginatedAbilities.isEmpty()) {
            int objectWidth = 32;
            int containerWidth = 209;
            int count = paginatedAbilities.size();
            int spacing = objectWidth + 8 + 3 * (maxEntries - count);
            xOff = containerWidth / 2 - (objectWidth * count + (spacing - objectWidth) * Math.max(count - 1, 0)) / 2;
            for (String entry2 : paginatedAbilities) {
                this.addRenderableWidget((GuiEventListener)new AbilityCardWidget(x + 77 + xOff, y + 153, this, entry2));
                xOff += spacing;
            }
        }
        this.addRenderableWidget((GuiEventListener)new RelicExperienceWidget(x + 142, y + 121, this));
        if (relic.isAbilityUpgradeEnabled(this.stack, ability)) {
            this.upgradeButton = (UpgradeAbilityActionWidget)this.addRenderableWidget((GuiEventListener)new UpgradeAbilityActionWidget(x + 288, y + 63, this));
        }
        if (relic.isAbilityRerollEnabled(this.stack, ability)) {
            this.rerollButton = (RerollAbilityActionWidget)this.addRenderableWidget((GuiEventListener)new RerollAbilityActionWidget(x + 288, y + 80, this));
        }
        if (relic.isAbilityResetEnabled(this.stack, ability)) {
            this.resetButton = (ResetAbilityActionWidget)this.addRenderableWidget((GuiEventListener)new ResetAbilityActionWidget(x + 288, y + 97, this));
        }
    }

    public void rebuildWidgets() {
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.minecraft.player, this.slot);
        super.rebuildWidgets();
    }

    public void tick() {
        super.tick();
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.minecraft.player, this.slot);
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        LocalPlayer player;
        block23: {
            block22: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = this.minecraft.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block22;
                relic = (IRelicItem)item;
                if (player != null) break block23;
            }
            return;
        }
        String ability = this.getSelectedAbility();
        if (relic.getAbilityData(ability) == null) {
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        int level = relic.getAbilityLevel(this.stack, ability);
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.SPACE_BACKGROUND);
        int x = (this.width - 418) / 2;
        int y = (this.height - 256) / 2;
        int yOff = 0;
        boolean xOff = false;
        GUIRenderer.begin(DescriptionTextures.SPACE_BACKGROUND, poseStack).texSize(418, 4096).patternSize(418, 256).pos((float)x + 209.0f, (float)y + 128.0f).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2)).end();
        GUIRenderer.begin(DescriptionTextures.TOP_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 107, y + 47).end();
        GUIRenderer.begin(DescriptionTextures.BOTTOM_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 60, y + 133).end();
        List<String> abilities = relic.getAbilitiesData().getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled(this.stack, (String)entry)).toList();
        if (abilities.size() > 5) {
            poseStack.pushPose();
            GUIRenderer.begin(DescriptionTextures.PAGE_COUNTER, poseStack).pos(x + 295, y + 177).end();
            MutableComponent page = Component.literal((String)String.valueOf(this.page + 1)).withStyle(ChatFormatting.BOLD);
            guiGraphics.drawString(this.minecraft.font, (Component)page, (int)((float)(x + 296) - (float)this.font.width((FormattedText)page) / 2.0f), y + 173, 16769656, true);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 1.0f);
        MutableComponent title = Component.translatableWithFallback((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + ability), (String)ability);
        if (!relic.isAbilityUnlocked(this.stack, ability)) {
            title = ScreenUtils.stylizeWithReplacement(title, 1.0, Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(10354864), (long)ability.length());
            RandomSource random = player.getRandom();
            float shakeX = MathUtils.randomFloat(random) * 0.5f;
            float shakeY = MathUtils.randomFloat(random) * 0.5f;
            poseStack.translate(shakeX, shakeY, 0.0f);
        } else {
            title.withStyle(ChatFormatting.BOLD);
        }
        guiGraphics.drawString(this.minecraft.font, (Component)title, (int)((float)(x + 113) * 1.33f), (int)((float)(y + 67) * 1.33f), 6696723, false);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 1.0f);
        yOff = 9;
        if (relic.isAbilityUnlocked(this.stack, ability)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            boolean wantsUpgrade = this.upgradeButton != null && this.upgradeButton.isHovered() && relic.mayUpgrade(this.stack, ability);
            boolean wantsReroll = this.rerollButton != null && this.rerollButton.isHovered() && relic.mayReroll(this.stack, ability);
            boolean wantsReset = this.resetButton != null && this.resetButton.isHovered() && relic.mayReset(this.stack, ability);
            int color = 6696723;
            for (StatData stat : relic.getAbilityData(ability).getStats().values()) {
                if (wantsUpgrade) {
                    color = 0x228B22;
                }
                if (wantsReroll) {
                    color = 16747520;
                }
                if (wantsReset) {
                    color = 0xB22222;
                }
                if (color != 6696723) {
                    float brightness = (float)(0.75 + (double)0.1f * Math.sin(4.71238898038469 * (double)player.tickCount / 20.0));
                    float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
                    hsb[2] = Mth.clamp((float)brightness, (float)0.0f, (float)1.0f);
                    color = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                }
                String value = String.valueOf(stat.getFormatValue().apply(relic.getStatValue(this.stack, ability, stat.getId(), wantsUpgrade ? level + 1 : (wantsReset ? 0 : level))));
                MutableComponent component = Component.literal((String)(value.endsWith(".0") ? value.replace(".0", "") : value)).withStyle(ChatFormatting.BOLD);
                components.add(component.withColor(color));
            }
            Pattern pattern = Pattern.compile("([^ .,!?;:]*%(\\d+)\\$s[^ .,!?;:]*)");
            ArrayList<CallSite> replacements = new ArrayList<CallSite>();
            for (int i = 1; i < 10; ++i) {
                replacements.add((CallSite)((Object)("%" + i + "$s")));
            }
            for (FormattedText line : this.font.getSplitter().splitLines(Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + ability + ".description"), (Object[])replacements.toArray()).getString(), 340, Style.EMPTY)) {
                String unformattedLine = line.getString().replace("%%", "%");
                int currentX = (x + 112) * 2;
                int currentY = (y + 74) * 2 + yOff;
                Matcher matcher = pattern.matcher(unformattedLine);
                int lastEnd = 0;
                while (matcher.find()) {
                    String dynamicSegment = matcher.group(1);
                    int index = Integer.parseInt(matcher.group(2)) - 1;
                    String staticText = unformattedLine.substring(lastEnd, matcher.start());
                    if (!staticText.isEmpty()) {
                        guiGraphics.drawString(this.font, staticText, currentX, currentY, 6696723, false);
                        currentX += this.font.width(staticText);
                    }
                    if (index < 0 || index >= components.size()) continue;
                    MutableComponent dynamicComponent = (MutableComponent)components.get(index);
                    MutableComponent dynamicValue = Component.literal((String)(dynamicSegment.substring(0, dynamicSegment.indexOf(37)) + dynamicComponent.getString() + dynamicSegment.substring(dynamicSegment.lastIndexOf(115) + 1))).withStyle(dynamicComponent.getStyle());
                    guiGraphics.drawString(this.font, (Component)dynamicValue, currentX + 2, currentY + 1, color, false);
                    int frameStartX = currentX - 1;
                    int frameStartY = currentY - 1;
                    int frameEndX = currentX + this.font.width((FormattedText)dynamicValue) + 4;
                    Objects.requireNonNull(this.font);
                    int frameEndY = currentY + 9 + 1;
                    guiGraphics.fill(frameStartX, frameStartY, frameEndX, frameStartY + 1, -16777216 + color);
                    guiGraphics.fill(frameStartX, frameEndY - 1, frameEndX, frameEndY, -16777216 + color);
                    guiGraphics.fill(frameStartX, frameStartY, frameStartX + 1, frameEndY, -16777216 + color);
                    guiGraphics.fill(frameEndX - 1, frameStartY, frameEndX, frameEndY, -16777216 + color);
                    currentX += this.font.width((FormattedText)dynamicValue) + 3;
                    lastEnd = matcher.end();
                }
                if (lastEnd < unformattedLine.length()) {
                    guiGraphics.drawString(this.font, unformattedLine.substring(lastEnd), currentX, currentY, 6696723, false);
                }
                yOff += 10;
            }
        } else {
            ArrayList<Number> placeholders = new ArrayList<Number>();
            for (StatData stat : relic.getAbilityData(ability).getStats().values()) {
                placeholders.add(stat.getFormatValue().apply(relic.getStatValue(this.stack, ability, stat.getId(), level)));
            }
            MutableComponent component = ScreenUtils.stylizeWithReplacement(Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + ability + ".description"), (Object[])placeholders.toArray()), 1.0, Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT), (long)ability.length());
            for (FormattedCharSequence line : this.font.split((FormattedText)component, 340)) {
                guiGraphics.drawString(this.font, line, (x + 112) * 2, (y + 74) * 2 + yOff, 6696723, false);
                yOff += 10;
            }
        }
        poseStack.popPose();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        this.screen.rebuildWidgets();
        Minecraft.getInstance().setScreen(this.screen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }

    @Override
    public DescriptionTab getTab() {
        return DescriptionTab.ABILITY;
    }

    @Override
    public int getContainer() {
        return this.container;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }
}

