/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.utilities.BlockEntry;

@OnlyIn(value=Dist.CLIENT)
public class PlaceChecker {
    public static boolean shouldPlaceBlock(Level world, BlockEntry blockEntry) {
        if (world == null || blockEntry == null) {
            return false;
        }
        BlockPos pos = blockEntry.blockPos;
        BlockState state = blockEntry.newBlockState;
        BlockEntity tileEntity = null;
        if (state == null) {
            return false;
        }
        BlockState toReplace = world.getBlockState(pos);
        BlockEntity toReplaceTE = world.getBlockEntity(pos);
        BlockState toReplaceOther = null;
        if (state.hasProperty((Property)BlockStateProperties.BED_PART) && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && state.getValue((Property)BlockStateProperties.BED_PART) == BedPart.FOOT) {
            toReplaceOther = world.getBlockState(pos.relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            toReplaceOther = world.getBlockState(pos.above());
        }
        if (toReplace == state) {
            return false;
        }
        if (toReplace.getDestroySpeed((BlockGetter)world, pos) == -1.0f || toReplaceOther != null && toReplaceOther.getDestroySpeed((BlockGetter)world, pos) == -1.0f) {
            return false;
        }
        if (EffortlessBuildingClient.BUILD_SETTINGS.shouldProtectTileEntities() && toReplaceOther != null && toReplaceOther.hasBlockEntity()) {
            return false;
        }
        boolean isNormalCube = state.isRedstoneConductor((BlockGetter)world, pos);
        return PlaceChecker.shouldPlace(world, pos, state, tileEntity, toReplace, toReplaceOther, isNormalCube);
    }

    private static boolean shouldPlace(Level level, BlockPos pos, BlockState state, BlockEntity tileEntity, BlockState toReplace, BlockState toReplaceOther, boolean isNormalCube) {
        return !PlaceChecker.shouldIgnoreBlockState(state);
    }

    private static boolean shouldIgnoreBlockState(BlockState state) {
        if (state.getBlock() == Blocks.STRUCTURE_VOID) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.BED_PART) && state.getValue((Property)BlockStateProperties.BED_PART) == BedPart.HEAD) {
            return true;
        }
        return state.getBlock() instanceof PistonHeadBlock;
    }
}

