/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.utilities.BlockEntry;

@OnlyIn(value=Dist.CLIENT)
public class ClientBlockUtilities {
    public static boolean determineIfLookingAtInteractiveObject(Minecraft mc, Level level) {
        boolean result = false;
        if (mc.hitResult != null) {
            BlockHitResult blockHitResult;
            BlockState blockState;
            if (mc.hitResult.getType() == HitResult.Type.BLOCK && (blockState = level.getBlockState((blockHitResult = (BlockHitResult)mc.hitResult).getBlockPos())).hasBlockEntity()) {
                result = true;
            }
            if (mc.hitResult.getType() == HitResult.Type.ENTITY) {
                result = true;
            }
        }
        return result;
    }

    public static void playSoundIfFurtherThanNormal(Player player, BlockEntry blockEntry, boolean breaking) {
        if (Minecraft.getInstance().hitResult != null && Minecraft.getInstance().hitResult.getType() == HitResult.Type.BLOCK) {
            return;
        }
        if (blockEntry == null || blockEntry.newBlockState == null) {
            return;
        }
        SoundType soundType = blockEntry.newBlockState.getBlock().getSoundType(blockEntry.newBlockState, (LevelReader)player.level(), blockEntry.blockPos, (Entity)player);
        SoundEvent soundEvent = breaking ? soundType.getBreakSound() : soundType.getPlaceSound();
        player.level().playSound(player, player.blockPosition(), soundEvent, SoundSource.BLOCKS, 0.6f, soundType.getPitch());
    }

    public static BlockHitResult getLookingAtFar(Player player) {
        Level world = player.level();
        float raytraceRange = AttachmentHandler.getPlacementReach(player, false);
        Vec3 look = player.getLookAngle();
        Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 end = new Vec3(player.getX() + look.x * (double)raytraceRange, player.getY() + (double)player.getEyeHeight() + look.y * (double)raytraceRange, player.getZ() + look.z * (double)raytraceRange);
        return world.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }
}

