/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.render.BuildRenderTypes;
import nl.requios.effortlessbuilding.render.ModifierRenderer;
import nl.requios.effortlessbuilding.systems.BuilderChain;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    private static final ChatFormatting highlightColor = ChatFormatting.DARK_AQUA;
    private static final ChatFormatting normalColor = ChatFormatting.WHITE;
    private static final Component placingText = Component.literal((String)(String.valueOf(normalColor) + "Left-click to " + String.valueOf(highlightColor) + "cancel, " + String.valueOf(normalColor) + "Right-click to " + String.valueOf(highlightColor) + "place"));
    private static final Component breakingText = Component.literal((String)(String.valueOf(normalColor) + "Left-click to " + String.valueOf(highlightColor) + "break, " + String.valueOf(normalColor) + "Right-click to " + String.valueOf(highlightColor) + "cancel"));

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        PoseStack ms = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        ms.pushPose();
        ms.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        ModifierRenderer.render(ms, buffer);
        ms.popPose();
    }

    @SubscribeEvent
    public static void onRenderGuiEvent(RenderGuiEvent.Post event) {
        RenderHandler.renderSubText(event.getGuiGraphics());
        RenderHandler.drawStacks(event.getGuiGraphics());
    }

    private static void renderSubText(GuiGraphics guiGraphics) {
        BuilderChain.BuildingState state = EffortlessBuildingClient.BUILDER_CHAIN.getBuildingState();
        if (state == BuilderChain.BuildingState.IDLE) {
            return;
        }
        Component text = state == BuilderChain.BuildingState.PLACING ? placingText : breakingText;
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        Font font = Minecraft.getInstance().font;
        PoseStack ms = guiGraphics.pose();
        ms.pushPose();
        ms.translate((double)screenWidth / 2.0, (double)(screenHeight - 54), 0.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int l = font.width((FormattedText)text);
        guiGraphics.drawString(font, text, (int)((float)(-l / 2)), -4, -1, true);
        RenderSystem.disableBlend();
        ms.popPose();
    }

    private static void drawStacks(GuiGraphics guiGraphics) {
        BuilderChain.BuildingState state = EffortlessBuildingClient.BUILDER_CHAIN.getBuildingState();
        if (state != BuilderChain.BuildingState.PLACING) {
            return;
        }
        Map<Item, Integer> stacks = EffortlessBuildingClient.ITEM_USAGE_TRACKER.total;
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.isCreative() && stacks.size() <= 1) {
            return;
        }
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int x = screenWidth / 2 + 10;
        int y = screenHeight / 2 - 8;
        int i = 0;
        for (Map.Entry<Item, Integer> stack : stacks.entrySet()) {
            int missing;
            int total = stack.getValue();
            if (total - (missing = EffortlessBuildingClient.ITEM_USAGE_TRACKER.getMissingCount(stack.getKey())) > 0) {
                RenderHandler.drawItemStack(guiGraphics, new ItemStack((ItemLike)stack.getKey(), total - missing), x + i * 20, y, false);
                ++i;
            }
            if (missing <= 0) continue;
            RenderHandler.drawItemStack(guiGraphics, new ItemStack((ItemLike)stack.getKey(), missing), x + i * 20, y, true);
            ++i;
        }
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, boolean missing) {
        guiGraphics.renderItem(stack, x, y);
        PoseStack ms = guiGraphics.pose();
        ms.pushPose();
        Font font = Minecraft.getInstance().font;
        String text = String.valueOf(stack.getCount());
        ms.translate(0.0, 0.0, 200.0);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        font.drawInBatch(text, (float)(x + 19 - 2 - font.width(text)), (float)(y + 6 + 3), (missing ? ChatFormatting.RED.getColor() : ChatFormatting.WHITE.getColor()).intValue(), true, ms.last().pose(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        multibuffersource$buffersource.endBatch();
        ms.popPose();
    }

    protected static VertexConsumer beginLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.getBuffer(BuildRenderTypes.LINES);
    }

    protected static void endLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.endBatch();
    }

    protected static VertexConsumer beginPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.getBuffer(BuildRenderTypes.PLANES);
    }

    protected static void endPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.endBatch();
    }
}

