/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network.message;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;

public record ModifierSettingsPacket(CompoundTag modifiersTag) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, ModifierSettingsPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ModifierSettingsPacket::modifiersTag, ModifierSettingsPacket::new);
    public static final CustomPacketPayload.Type<ModifierSettingsPacket> ID = new CustomPacketPayload.Type(EffortlessBuilding.asResource("modifier_settings"));
    private static final String DATA_KEY = "effortlessbuilding:buildModifiers";

    public ModifierSettingsPacket(Player player) {
        this(player.getPersistentData().getCompound(DATA_KEY));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class ClientHandler {
        public static void handleClient(ModifierSettingsPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                if (context.flow().isClientbound()) {
                    Player player = context.player();
                    EffortlessBuildingClient.BUILD_MODIFIERS.deserializeNBT(packet.modifiersTag());
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"effortlessbuilding.networking.modifier_settings.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }

    public static class ServerHandler {
        public static void handleServer(ModifierSettingsPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp;
                if (context.flow().isServerbound() && (patt0$temp = context.player()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    player.getPersistentData().put(ModifierSettingsPacket.DATA_KEY, (Tag)packet.modifiersTag());
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"effortlessbuilding.networking.modifier_settings.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

