/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.systems.ServerBuildState;

public record IsQuickReplacingPacket(boolean isQuickReplacing) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, IsQuickReplacingPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, IsQuickReplacingPacket::isQuickReplacing, IsQuickReplacingPacket::new);
    public static final CustomPacketPayload.Type<IsQuickReplacingPacket> ID = new CustomPacketPayload.Type(EffortlessBuilding.asResource("is_quick_replacing"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(IsQuickReplacingPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ServerBuildState.setIsQuickReplacing((Player)player, packet.isQuickReplacing());
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"effortlessbuilding.networking.is_quick_replacing.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

