/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForge;
import nl.requios.effortlessbuilding.gui.elements.SlotGui;

@OnlyIn(value=Dist.CLIENT)
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GuiScrollPane
extends SlotGui {
    public Screen parent;
    public Font font;
    private final List<IScrollEntry> listEntries;
    private float scrollMultiplier = 1.0f;
    private int mouseX;
    private int mouseY;

    public GuiScrollPane(Screen parent, Font font, int top, int bottom) {
        super(Minecraft.getInstance(), parent.width, parent.height, top, bottom, 100);
        this.parent = parent;
        this.font = font;
        this.renderSelection = false;
        this.listEntries = new ArrayList<IScrollEntry>();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public IScrollEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public void AddListEntry(IScrollEntry listEntry) {
        this.listEntries.add(listEntry);
    }

    @Override
    protected int getItemCount() {
        return this.listEntries.size();
    }

    @Override
    protected boolean isSelectedItem(int slotIndex) {
        return false;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 15;
    }

    @Override
    public int getRowWidth() {
        return 280;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.visible) {
            this.mouseX = mouseXIn;
            this.mouseY = mouseYIn;
            this.renderBackground();
            int scrollbarLeft = this.getScrollbarPosition();
            int scrollbarRight = scrollbarLeft + 6;
            this.capYPosition();
            Tesselator tessellator = Tesselator.getInstance();
            int insideLeft = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
            int insideTop = this.y0 + 4 - (int)this.yo;
            if (this.renderHeader) {
                this.renderHeader(insideLeft, insideTop, tessellator);
            }
            this.renderList(guiGraphics, insideLeft, insideTop, mouseXIn, mouseYIn, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            int maxScroll = this.getMaxScroll();
            if (maxScroll > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                int l1 = (int)this.yo * (this.y1 - this.y0 - (k1 = Mth.clamp((int)k1, (int)32, (int)(this.y1 - this.y0 - 8)))) / maxScroll + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                bufferbuilder.addVertex((float)scrollbarLeft, (float)this.y1, 0.0f).setUv(0.0f, 1.0f).setColor(0, 0, 0, 255);
                bufferbuilder.addVertex((float)scrollbarRight, (float)this.y1, 0.0f).setUv(1.0f, 1.0f).setColor(0, 0, 0, 255);
                bufferbuilder.addVertex((float)scrollbarRight, (float)this.y0, 0.0f).setUv(1.0f, 0.0f).setColor(0, 0, 0, 255);
                bufferbuilder.addVertex((float)scrollbarLeft, (float)this.y0, 0.0f).setUv(0.0f, 0.0f).setColor(0, 0, 0, 255);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                bufferbuilder.addVertex((float)scrollbarLeft, (float)(l1 + k1), 0.0f).setUv(0.0f, 1.0f).setColor(128, 128, 128, 255);
                bufferbuilder.addVertex((float)scrollbarRight, (float)(l1 + k1), 0.0f).setUv(1.0f, 1.0f).setColor(128, 128, 128, 255);
                bufferbuilder.addVertex((float)scrollbarRight, (float)l1, 0.0f).setUv(1.0f, 0.0f).setColor(128, 128, 128, 255);
                bufferbuilder.addVertex((float)scrollbarLeft, (float)l1, 0.0f).setUv(0.0f, 0.0f).setColor(128, 128, 128, 255);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                bufferbuilder.addVertex((float)scrollbarLeft, (float)(l1 + k1 - 1), 0.0f).setUv(0.0f, 1.0f).setColor(192, 192, 192, 255);
                bufferbuilder.addVertex((float)(scrollbarRight - 1), (float)(l1 + k1 - 1), 0.0f).setUv(1.0f, 1.0f).setColor(192, 192, 192, 255);
                bufferbuilder.addVertex((float)(scrollbarRight - 1), (float)l1, 0.0f).setUv(1.0f, 0.0f).setColor(192, 192, 192, 255);
                bufferbuilder.addVertex((float)scrollbarLeft, (float)l1, 0.0f).setUv(0.0f, 0.0f).setColor(192, 192, 192, 255);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            }
            RenderSystem.disableBlend();
        }
    }

    @Override
    protected int getMaxPosition() {
        int height = this.headerHeight;
        for (IScrollEntry entry : this.listEntries) {
            height += entry.getHeight();
        }
        return height;
    }

    @Override
    protected void renderBackground() {
    }

    @Override
    protected void renderItem(GuiGraphics guiGraphics, int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        this.getListEntry(slotIndex).drawEntry(guiGraphics, slotIndex, xPos, yPos, this.getRowWidth(), heightIn, mouseXIn, mouseYIn, this.getSlotIndexFromScreenCoords(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    public int getMaxPosition(int count) {
        int height = this.headerHeight;
        for (int i = 0; i < count; ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            height += entry.getHeight();
        }
        return height;
    }

    public int getSlotIndexFromScreenCoords(double posX, double posY) {
        int left = this.x0 + (this.width - this.getRowWidth()) / 2;
        int right = this.x0 + (this.width + this.getRowWidth()) / 2;
        double relativeMouseY = this.getRelativeMouseY(this.mouseY, 0);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            if (relativeMouseY <= (double)entry.getHeight()) {
                return posX < (double)this.getScrollbarPosition() && posX >= (double)left && posX <= (double)right && i >= 0 && relativeMouseY >= 0.0 && i < this.getItemCount() ? i : -1;
            }
            relativeMouseY -= (double)entry.getHeight();
        }
        return -1;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int selectedSlot = this.getSlotIndexFromScreenCoords(mouseX, mouseY);
        double relativeX = this.getRelativeMouseX(mouseX);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mousePressed(selectedSlot, (int)mouseX, (int)mouseY, button, (int)relativeX, (int)relativeY);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int pButton) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            double relativeX = this.getRelativeMouseX(mouseX);
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mouseReleased(i, (int)mouseX, (int)mouseY, pButton, (int)relativeX, (int)relativeY);
        }
        this.visible = true;
        return false;
    }

    public void handleMouseInput() {
        if (this.isMouseInList(this.mouseX, this.mouseY)) {
            if (this.minecraft.mouseHandler.isLeftPressed() && this.mouseY >= this.y0 && this.mouseY <= this.y1) {
                int i = this.x0 + (this.width - this.getRowWidth()) / 2;
                int j = this.x0 + (this.width + this.getRowWidth()) / 2;
                int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                if (slotIndex > -1) {
                    this.mouseClicked(this.mouseX, this.mouseY, 0);
                } else if (this.mouseX >= i && this.mouseX <= j && relativeMouseY < 0.0) {
                    this.clickedHeader(this.mouseX - i, this.mouseY - this.y0 + (int)this.yo - 4);
                }
            }
            if (this.minecraft.mouseHandler.isLeftPressed() && this.isVisible()) {
                if (this.yDrag == -1) {
                    boolean flag1 = true;
                    if (this.mouseY >= this.y0 && this.mouseY <= this.y1) {
                        int i2 = this.x0 + (this.width - this.getRowWidth()) / 2;
                        int j2 = this.x0 + (this.width + this.getRowWidth()) / 2;
                        int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                        double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                        if (slotIndex > -1) {
                            this.mouseClicked(slotIndex, this.mouseX, this.mouseY);
                        } else if (this.mouseX >= i2 && this.mouseX <= j2 && relativeMouseY < 0.0) {
                            this.clickedHeader(this.mouseX - i2, this.mouseY - this.y0 + (int)this.yo - 4);
                            flag1 = false;
                        }
                        int i3 = this.getScrollbarPosition();
                        int j1 = i3 + 6;
                        if (this.mouseX >= i3 && this.mouseX <= j1) {
                            this.scrollMultiplier = -1.0f;
                            int maxScroll = this.getMaxScroll();
                            if (maxScroll < 1) {
                                maxScroll = 1;
                            }
                            int l1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                            l1 = Mth.clamp((int)l1, (int)32, (int)(this.y1 - this.y0 - 8));
                            this.scrollMultiplier /= (float)(this.y1 - this.y0 - l1) / (float)maxScroll;
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.yDrag = flag1 ? this.mouseY : -2;
                    } else {
                        this.yDrag = -2;
                    }
                } else if (this.yDrag >= 0) {
                    this.yo -= (double)((float)(this.mouseY - this.yDrag) * this.scrollMultiplier);
                    this.yDrag = this.mouseY;
                }
            } else {
                this.yDrag = -1;
            }
        }
    }

    @Override
    protected void renderList(GuiGraphics guiGraphics, int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int insideHeight;
        int itemCount = this.getItemCount();
        Tesselator tessellator = Tesselator.getInstance();
        int y = this.headerHeight + insideTop;
        int contentHeight = this.getMaxPosition();
        if (contentHeight < (insideHeight = this.y1 - this.y0 - 4)) {
            y += (insideHeight - contentHeight) / 2;
        }
        for (int i = 0; i < itemCount; ++i) {
            int entryHeight = this.listEntries.get(i).getHeight();
            int entryHeight2 = entryHeight - 4;
            if (y > this.y1 || y + entryHeight2 < this.y0) {
                this.updateItemPosition(i, insideLeft, y, partialTicks);
            }
            if (this.renderSelection && this.isSelectedItem(i)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)1.0f);
                BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                bufferbuilder.addVertex((float)i1, (float)(y + entryHeight2 + 2), 0.0f);
                bufferbuilder.addVertex((float)j1, (float)(y + entryHeight2 + 2), 0.0f);
                bufferbuilder.addVertex((float)j1, (float)(y - 2), 0.0f);
                bufferbuilder.addVertex((float)i1, (float)(y - 2), 0.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                bufferbuilder.addVertex((float)(i1 + 1), (float)(y + entryHeight2 + 1), 0.0f);
                bufferbuilder.addVertex((float)(j1 - 1), (float)(y + entryHeight2 + 1), 0.0f);
                bufferbuilder.addVertex((float)(j1 - 1), (float)(y - 1), 0.0f);
                bufferbuilder.addVertex((float)(i1 + 1), (float)(y - 1), 0.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            }
            this.renderItem(guiGraphics, i, insideLeft, y, entryHeight2, mouseXIn, mouseYIn, partialTicks);
            y += entryHeight;
        }
    }

    private double getRelativeMouseX(double mouseX) {
        int j = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
        return mouseX - (double)j;
    }

    private double getRelativeMouseY(double mouseY, int contentIndex) {
        int insideHeight;
        int k = this.y0 + 4 - this.getScroll() + this.getMaxPosition(contentIndex) + this.headerHeight;
        double relativeMouseY = mouseY - (double)k;
        int contentHeight = this.getMaxPosition();
        if (contentHeight < (insideHeight = this.y1 - this.y0 - 4)) {
            relativeMouseY -= (double)((float)(insideHeight - contentHeight) / 2.0f);
        }
        return relativeMouseY;
    }

    public void init(List<Renderable> renderables) {
        for (IScrollEntry entry : this.listEntries) {
            entry.init(renderables);
        }
    }

    public void updateScreen() {
        for (IScrollEntry entry : this.listEntries) {
            entry.updateScreen();
        }
    }

    public void drawTooltip(GuiGraphics guiGraphics, Screen guiScreen, int mouseX, int mouseY) {
        for (IScrollEntry entry : this.listEntries) {
            entry.drawTooltip(guiGraphics, guiScreen, mouseX, mouseY);
        }
    }

    @Override
    public boolean charTyped(char eventChar, int eventKey) {
        for (IScrollEntry entry : this.listEntries) {
            entry.charTyped(eventChar, eventKey);
        }
        return false;
    }

    public void onGuiClosed() {
        for (IScrollEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static interface IScrollEntry {
        public void init(List<Renderable> var1);

        public void updateScreen();

        public void drawTooltip(GuiGraphics var1, Screen var2, int var3, int var4);

        public boolean charTyped(char var1, int var2);

        public void onGuiClosed();

        public int getHeight();

        public void updatePosition(int var1, int var2, int var3, float var4);

        public void drawEntry(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean mousePressed(int var1, int var2, int var3, int var4, int var5, int var6);

        public void mouseReleased(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

