/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmode;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import nl.requios.effortlessbuilding.EffortlessBuilding;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlayerSettingsGui
extends Screen {
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected boolean showShaderList = false;
    private Button shaderTypeButton;
    private ShaderTypeList shaderTypeList;
    private Button closeButton;

    public PlayerSettingsGui() {
        super((Component)Component.translatable((String)"effortlessbuilding.screen.player_settings"));
    }

    protected void init() {
        this.left = this.width / 2 - 140;
        this.right = this.width / 2 + 140;
        this.top = this.height / 2 - 100;
        this.bottom = this.height / 2 + 100;
        int yy = this.top;
        this.shaderTypeList = new ShaderTypeList(this.minecraft);
        this.addWidget((GuiEventListener)this.shaderTypeList);
        Component currentShaderName = ShaderType.DISSOLVE_BLUE.name;
        this.shaderTypeButton = new ExtendedButton(this.right - 180, yy, 180, 20, currentShaderName, button -> {
            this.showShaderList = !this.showShaderList;
        });
        this.addRenderableOnly((Renderable)this.shaderTypeButton);
        ExtendedSlider slider = new ExtendedSlider(this.right - 200, yy += 50, 200, 20, (Component)Component.empty(), (Component)Component.empty(), 0.5, 2.0, 1.0, true);
        this.addRenderableOnly((Renderable)slider);
        this.closeButton = new ExtendedButton(this.left + 50, this.bottom - 20, 180, 20, (Component)Component.literal((String)"Done"), button -> this.minecraft.player.closeContainer());
        this.addRenderableOnly((Renderable)this.closeButton);
    }

    public void tick() {
        super.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int yy = this.top;
        guiGraphics.drawString(this.font, "Shader type", this.left, yy + 5, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Shader speed", this.left, (yy += 50) + 5, 0xFFFFFF, false);
        if (this.showShaderList) {
            this.shaderTypeList.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.showShaderList && !this.shaderTypeList.isMouseOver(mouseX, mouseY) && !this.shaderTypeButton.isMouseOver(mouseX, mouseY)) {
            this.showShaderList = false;
        }
        return true;
    }

    public void removed() {
        ShaderTypeList.ShaderTypeEntry selectedShader = (ShaderTypeList.ShaderTypeEntry)this.shaderTypeList.getSelected();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ShaderTypeList
    extends ObjectSelectionList<ShaderTypeEntry> {
        public ShaderTypeList(Minecraft mcIn) {
            super(mcIn, 180, 140, PlayerSettingsGui.this.top + 20, 18);
            this.setX(PlayerSettingsGui.this.right - this.width);
            for (int i = 0; i < 40; ++i) {
                for (ShaderType shaderType : ShaderType.values()) {
                    ShaderTypeEntry shaderTypeEntry = new ShaderTypeEntry(shaderType);
                    this.addEntry((AbstractSelectionList.Entry)shaderTypeEntry);
                }
            }
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((ShaderTypeEntry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return this.width;
        }

        public void setSelected(ShaderTypeEntry selected) {
            super.setSelected((AbstractSelectionList.Entry)selected);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            EffortlessBuilding.log("Selected shader " + String.valueOf(selected.shaderType.name));
            PlayerSettingsGui.this.shaderTypeButton.setMessage(selected.shaderType.name);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int pButton) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseClicked(mouseX, mouseY, pButton);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.isMouseOver(mouseX, mouseY);
        }

        public boolean isFocused() {
            return PlayerSettingsGui.this.getFocused() == this;
        }

        protected int getScrollbarPosition() {
            return PlayerSettingsGui.this.right - 6;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class ShaderTypeEntry
        extends ObjectSelectionList.Entry<ShaderTypeEntry> {
            private final ShaderType shaderType;

            public ShaderTypeEntry(ShaderType shaderType) {
                this.shaderType = shaderType;
            }

            public void render(GuiGraphics guiGraphics, int itemIndex, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                if (rowTop + 10 > ShaderTypeList.this.getY() && rowTop + rowHeight - 5 < ShaderTypeList.this.getY() + ShaderTypeList.this.getHeight()) {
                    guiGraphics.drawString(PlayerSettingsGui.this.font, this.shaderType.name, ShaderTypeList.this.getX() + 8, rowTop + 4, 0xFFFFFF, false);
                }
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    ShaderTypeList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            public Component getNarration() {
                return null;
            }
        }
    }

    public static enum ShaderType {
        DISSOLVE_BLUE("Dissolve Blue"),
        DISSOLVE_ORANGE("Dissolve Orange");

        public Component name;

        private ShaderType(Component name) {
            this.name = name;
        }

        private ShaderType(String name) {
            this.name = Component.literal((String)name);
        }
    }
}

