/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import nl.requios.effortlessbuilding.create.Create;
import nl.requios.effortlessbuilding.create.foundation.virtualWorld.VirtualRenderWorld;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BlockEntityRenderHelper {
    public static void renderBlockEntities(Level world, Iterable<BlockEntity> customRenderBEs, PoseStack ms, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer);
    }

    public static void renderBlockEntities(Level world, Iterable<BlockEntity> customRenderBEs, PoseStack ms, MultiBufferSource buffer, float pt) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer, pt);
    }

    public static void renderBlockEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderBEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, renderWorld, customRenderBEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderBlockEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderBEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer, float pt) {
        Iterator<BlockEntity> iterator = customRenderBEs.iterator();
        while (iterator.hasNext()) {
            BlockEntity blockEntity = iterator.next();
            if (VisualizationManager.supportsVisualization((LevelAccessor)world) && VisualizationHelper.skipVanillaRender((BlockEntity)blockEntity)) continue;
            BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            BlockPos pos = blockEntity.getBlockPos();
            ms.pushPose();
            TransformStack.of((PoseStack)ms).translate((Vec3i)pos);
            try {
                int worldLight = BlockEntityRenderHelper.getCombinedLight(world, BlockEntityRenderHelper.getLightPos(lightTransform, pos), renderWorld, pos);
                if (renderWorld != null) {
                    blockEntity.setLevel((Level)renderWorld);
                    renderer.render(blockEntity, pt, ms, buffer, worldLight, OverlayTexture.NO_OVERLAY);
                    blockEntity.setLevel(world);
                } else {
                    renderer.render(blockEntity, pt, ms, buffer, worldLight, OverlayTexture.NO_OVERLAY);
                }
            }
            catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + RegisteredObjectsHelper.getKeyOrThrow((BlockEntityType)blockEntity.getType()).toString() + " could not be rendered virtually.";
                Create.LOGGER.error(message, (Throwable)e);
            }
            ms.popPose();
        }
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.getX() + 0.5f, (float)contraptionPos.getY() + 0.5f, (float)contraptionPos.getZ() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return BlockPos.containing((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }

    public static int getCombinedLight(Level world, BlockPos worldPos, @Nullable VirtualRenderWorld renderWorld, BlockPos renderWorldPos) {
        int worldLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)worldPos);
        if (renderWorld != null) {
            int renderWorldLight = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)renderWorldPos);
            return SuperByteBuffer.maxLight((int)worldLight, (int)renderWorldLight);
        }
        return worldLight;
    }
}

