/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nl.requios.effortlessbuilding.create.foundation.item.TooltipHelper;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.create.foundation.utility.Lang;

public class ItemDescription {
    public static final ItemDescription MISSING = new ItemDescription(null);
    public static Component trim = Components.literal("                          ").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.STRIKETHROUGH});
    private List<Component> lines;
    private List<Component> linesOnShift;
    private List<Component> linesOnCtrl;
    private Palette palette;

    public ItemDescription(Palette palette) {
        this.palette = palette;
        this.lines = new ArrayList<Component>();
        this.linesOnShift = new ArrayList<Component>();
        this.linesOnCtrl = new ArrayList<Component>();
    }

    public ItemDescription withSummary(Component summary) {
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutTextComponent(summary, this.palette.color, this.palette.hColor));
        return this;
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            bar = (String)bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = (String)bar + "\u2592";
        }
        return (String)bar + " ";
    }

    public ItemDescription withBehaviour(String condition, String behaviour) {
        ItemDescription.add(this.linesOnShift, (Component)Components.literal(condition).withStyle(ChatFormatting.GRAY));
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutStringTextComponent(behaviour, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription withControl(String condition, String action) {
        ItemDescription.add(this.linesOnCtrl, (Component)Components.literal(condition).withStyle(ChatFormatting.GRAY));
        ItemDescription.addStrings(this.linesOnCtrl, TooltipHelper.cutStringTextComponent(action, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription createTabs() {
        boolean hasControls;
        boolean hasDescription = !this.linesOnShift.isEmpty();
        boolean bl = hasControls = !this.linesOnCtrl.isEmpty();
        if (hasDescription || hasControls) {
            String[] holdDesc = Lang.translateDirect("tooltip.holdForDescription", "$").getString().split("\\$");
            String[] holdCtrl = Lang.translateDirect("tooltip.holdForControls", "$").getString().split("\\$");
            MutableComponent keyShift = Lang.translateDirect("tooltip.keyShift", new Object[0]);
            MutableComponent keyCtrl = Lang.translateDirect("tooltip.keyCtrl", new Object[0]);
            for (List list : Arrays.asList(this.lines, this.linesOnShift, this.linesOnCtrl)) {
                MutableComponent tabBuilder;
                boolean ctrl;
                boolean shift = list == this.linesOnShift;
                boolean bl2 = ctrl = list == this.linesOnCtrl;
                if (holdDesc.length != 2 || holdCtrl.length != 2) {
                    list.add(0, Components.literal("Invalid lang formatting!"));
                    continue;
                }
                if (hasControls) {
                    tabBuilder = Components.empty();
                    tabBuilder.append((Component)Components.literal(holdCtrl[0]).withStyle(ChatFormatting.DARK_GRAY));
                    tabBuilder.append((Component)keyCtrl.plainCopy().withStyle(ctrl ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    tabBuilder.append((Component)Components.literal(holdCtrl[1]).withStyle(ChatFormatting.DARK_GRAY));
                    list.add(0, tabBuilder);
                }
                if (hasDescription) {
                    tabBuilder = Components.empty();
                    tabBuilder.append((Component)Components.literal(holdDesc[0]).withStyle(ChatFormatting.DARK_GRAY));
                    tabBuilder.append((Component)keyShift.plainCopy().withStyle(shift ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    tabBuilder.append((Component)Components.literal(holdDesc[1]).withStyle(ChatFormatting.DARK_GRAY));
                    list.add(0, tabBuilder);
                }
                if (!shift && !ctrl) continue;
                list.add(hasDescription && hasControls ? 2 : 1, Components.immutableEmpty());
            }
        }
        if (!hasDescription) {
            this.linesOnShift = this.lines;
        }
        if (!hasControls) {
            this.linesOnCtrl = this.lines;
        }
        return this;
    }

    public static String hightlight(String s, Palette palette) {
        return String.valueOf(palette.hColor) + s + String.valueOf(palette.color);
    }

    public static void addStrings(List<Component> infoList, List<Component> textLines) {
        textLines.forEach(s -> ItemDescription.add(infoList, s));
    }

    public static void add(List<Component> infoList, List<Component> textLines) {
        infoList.addAll(textLines);
    }

    public static void add(List<Component> infoList, Component line) {
        infoList.add(line);
    }

    public Palette getPalette() {
        return this.palette;
    }

    public List<Component> addInformation(List<Component> tooltip) {
        if (Screen.hasShiftDown()) {
            tooltip.addAll(this.linesOnShift);
            return tooltip;
        }
        if (Screen.hasControlDown()) {
            tooltip.addAll(this.linesOnCtrl);
            return tooltip;
        }
        tooltip.addAll(this.lines);
        return tooltip;
    }

    public List<Component> getLines() {
        return this.lines;
    }

    public List<Component> getLinesOnCtrl() {
        return this.linesOnCtrl;
    }

    public List<Component> getLinesOnShift() {
        return this.linesOnShift;
    }

    public static enum Palette {
        Blue(ChatFormatting.BLUE, ChatFormatting.AQUA),
        Green(ChatFormatting.DARK_GREEN, ChatFormatting.GREEN),
        Yellow(ChatFormatting.GOLD, ChatFormatting.YELLOW),
        Red(ChatFormatting.DARK_RED, ChatFormatting.RED),
        Purple(ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE),
        Gray(ChatFormatting.DARK_GRAY, ChatFormatting.GRAY);

        public ChatFormatting color;
        public ChatFormatting hColor;

        private Palette(ChatFormatting primary, ChatFormatting highlight) {
            this.color = primary;
            this.hColor = highlight;
        }
    }
}

