/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.TickableGuiEventListener;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.AbstractSimiWidget;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreenList;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSimiScreen
extends Screen {
    protected int windowWidth;
    protected int windowHeight;
    protected int windowXOffset;
    protected int windowYOffset;
    protected int guiLeft;
    protected int guiTop;

    protected AbstractSimiScreen(Component title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this(Components.immutableEmpty());
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void init() {
        this.guiLeft = (this.width - this.windowWidth) / 2;
        this.guiTop = (this.height - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
    }

    public void tick() {
        for (GuiEventListener listener : this.children()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.getFocused() != null && !this.getFocused().isMouseOver(pMouseX, pMouseY)) {
            this.setFocused(null);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(Collection<W> widgets) {
        for (GuiEventListener widget : widgets) {
            this.addRenderableWidget(widget);
        }
    }

    protected void removeWidgets(GuiEventListener ... widgets) {
        for (GuiEventListener widget : widgets) {
            this.removeWidget(widget);
        }
    }

    protected void removeWidgets(Collection<? extends GuiEventListener> widgets) {
        for (GuiEventListener guiEventListener : widgets) {
            this.removeWidget(guiEventListener);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = AnimationTickHolder.getPartialTicksUI();
        PoseStack ms = graphics.pose();
        ms.pushPose();
        this.prepareFrame();
        this.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderWindow(graphics, mouseX, mouseY, partialTicks);
        this.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        this.endFrame();
        ms.popPose();
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.keyPressed(keyCode, scanCode, modifiers);
        if (keyPressed || this.getFocused() instanceof EditBox) {
            return keyPressed;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void prepareFrame() {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(graphics);
    }

    protected abstract void renderWindow(GuiGraphics var1, int var2, int var3, float var4);

    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable widget : this.renderables) {
            AbstractSimiWidget simiWidget;
            if (widget instanceof AbstractSimiWidget && (simiWidget = (AbstractSimiWidget)widget).isMouseOver(mouseX, mouseY) && simiWidget.visible) {
                List<Component> tooltip = simiWidget.getToolTip();
                if (tooltip.isEmpty()) continue;
                int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.getX();
                int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.getY();
                graphics.renderComponentTooltip(this.font, tooltip, ttx, tty);
            }
            if (!(widget instanceof ModifiersScreenList)) continue;
            ModifiersScreenList list = (ModifiersScreenList)widget;
            list.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void endFrame() {
    }

    @Deprecated
    protected void debugWindowArea(GuiGraphics graphics) {
        graphics.fill(this.guiLeft + this.windowWidth, this.guiTop + this.windowHeight, this.guiLeft, this.guiTop, -741092397);
    }

    public GuiEventListener getFocused() {
        GuiEventListener focused = super.getFocused();
        if (focused instanceof AbstractWidget && !((AbstractWidget)focused).isFocused()) {
            focused = null;
        }
        this.setFocused(focused);
        return focused;
    }
}

