/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

public class Array
extends BaseModifier {
    public Vec3i offset = BlockPos.ZERO;
    public int count = 5;

    @Override
    public void findCoordinates(BlockSet blocks, Player player) {
        if (!this.enabled || this.offset.getX() == 0 && this.offset.getY() == 0 && this.offset.getZ() == 0) {
            return;
        }
        BlockSet originalBlocks = new BlockSet(blocks);
        for (BlockEntry blockEntry : originalBlocks) {
            BlockPos pos = blockEntry.blockPos;
            for (int i = 0; i < this.count; ++i) {
                if (blocks.containsKey(pos = pos.offset(this.offset))) continue;
                BlockEntry newBlockEntry = new BlockEntry(pos);
                newBlockEntry.copyRotationSettingsFrom(blockEntry);
                blocks.add(newBlockEntry);
            }
        }
    }

    @Override
    public void onPowerLevelChanged(int powerLevel) {
    }

    public int getReach() {
        int x = Math.abs(this.offset.getX());
        int y = Math.abs(this.offset.getY());
        int z = Math.abs(this.offset.getZ());
        int largestOffset = Math.max(Math.max(x, y), z);
        return largestOffset * this.count;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.putIntArray("offset", new int[]{this.offset.getX(), this.offset.getY(), this.offset.getZ()});
        compound.putInt("count", this.count);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        int[] offsetArray = compound.getIntArray("offset");
        this.offset = new Vec3i(offsetArray[0], offsetArray[1], offsetArray[2]);
        this.count = compound.getInt("count");
    }
}

