/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.attachment;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import nl.requios.effortlessbuilding.CommonConfig;

public class PowerLevel
implements INBTSerializable<CompoundTag> {
    public static final int MAX_POWER_LEVEL = 3;
    private int powerLevel = 0;

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public int getNextPowerLevel() {
        return Math.min(this.getPowerLevel() + 1, 3);
    }

    public void setPowerLevel(int powerLevel) {
        this.powerLevel = powerLevel;
    }

    public boolean canIncreasePowerLevel() {
        return this.getPowerLevel() < 3;
    }

    public void increasePowerLevel() {
        if (this.canIncreasePowerLevel()) {
            this.setPowerLevel(this.getPowerLevel() + 1);
        }
    }

    public int getPlacementReach(Player player, boolean nextPowerLevel) {
        if (player.isCreative()) {
            return (Integer)CommonConfig.reach.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.reach.level1.get();
            case 2 -> (Integer)CommonConfig.reach.level2.get();
            case 3 -> (Integer)CommonConfig.reach.level3.get();
            default -> (Integer)CommonConfig.reach.level0.get();
        };
    }

    public int getBuildModeReach(Player player) {
        return this.getPlacementReach(player, false) + 6;
    }

    public int getMaxBlocksPlacedAtOnce(Player player, boolean nextPowerLevel) {
        if (player.isCreative()) {
            return (Integer)CommonConfig.maxBlocksPlacedAtOnce.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level1.get();
            case 2 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level2.get();
            case 3 -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level3.get();
            default -> (Integer)CommonConfig.maxBlocksPlacedAtOnce.level0.get();
        };
    }

    public int getMaxBlocksPerAxis(Player player, boolean nextPowerLevel) {
        if (player.isCreative()) {
            return (Integer)CommonConfig.maxBlocksPerAxis.creative.get();
        }
        return switch (nextPowerLevel ? this.getNextPowerLevel() : this.getPowerLevel()) {
            case 1 -> (Integer)CommonConfig.maxBlocksPerAxis.level1.get();
            case 2 -> (Integer)CommonConfig.maxBlocksPerAxis.level2.get();
            case 3 -> (Integer)CommonConfig.maxBlocksPerAxis.level3.get();
            default -> (Integer)CommonConfig.maxBlocksPerAxis.level0.get();
        };
    }

    public int getMaxMirrorRadius(Player player, boolean nextPowerLevel) {
        if (player.isCreative()) {
            return (Integer)CommonConfig.maxMirrorRadius.creative.get();
        }
        return switch (this.getPowerLevel() + (nextPowerLevel ? 1 : 0)) {
            case 1 -> (Integer)CommonConfig.maxMirrorRadius.level1.get();
            case 2 -> (Integer)CommonConfig.maxMirrorRadius.level2.get();
            case 3 -> (Integer)CommonConfig.maxMirrorRadius.level3.get();
            default -> (Integer)CommonConfig.maxMirrorRadius.level0.get();
        };
    }

    public boolean isDisabled(Player player) {
        return this.getMaxBlocksPlacedAtOnce(player, false) <= 0 || this.getMaxBlocksPerAxis(player, false) <= 0;
    }

    public boolean canBreakFar(Player player) {
        return player.getAbilities().instabuild;
    }

    public boolean canReplaceBlocks(Player player) {
        return player.getAbilities().instabuild;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("powerLevel", this.getPowerLevel());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setPowerLevel(nbt.getInt("powerLevel"));
    }
}

