/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.gui.buildmode.PlayerSettingsGui;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreen;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static KeyMapping[] keyBindings;
    public static int ticksInGame;
    private static int placeCooldown;
    private static int breakCooldown;

    @SubscribeEvent
    public static void onClientTickPre(ClientTickEvent.Pre event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        EffortlessBuildingClient.BUILDER_CHAIN.onTick();
        ClientEvents.onMouseInput();
        EffortlessBuildingClient.BLOCK_PREVIEWS.onTick();
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        Screen gui = Minecraft.getInstance().screen;
        if (gui == null || !gui.isPauseScreen()) {
            ++ticksInGame;
        }
    }

    private static void onMouseInput() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        BuildModeEnum buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
        if (mc.screen != null || RadialMenu.instance.isVisible()) {
            return;
        }
        if (mc.options.keyUse.isDown()) {
            if (placeCooldown <= 0) {
                placeCooldown = 4;
                EffortlessBuildingClient.BUILDER_CHAIN.onRightClick();
            } else if (buildMode == BuildModeEnum.SINGLE) {
                --placeCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    placeCooldown = 0;
                }
            }
        } else {
            placeCooldown = 0;
        }
        if (mc.options.keyAttack.isDown()) {
            if (breakCooldown <= 0) {
                breakCooldown = 4;
                EffortlessBuildingClient.BUILDER_CHAIN.onLeftClick();
            } else if (buildMode == BuildModeEnum.SINGLE) {
                --breakCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    breakCooldown = 0;
                }
            }
        } else {
            breakCooldown = 0;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onKeyPress(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (keyBindings[0].isDown()) {
            if (!AttachmentHandler.isDisabled((Player)player)) {
                if (!RadialMenu.instance.isVisible()) {
                    Minecraft.getInstance().setScreen((Screen)RadialMenu.instance);
                }
            } else {
                EffortlessBuilding.log((Player)player, "Build modes are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
            }
        }
        if (keyBindings[1].consumeClick()) {
            ClientEvents.openModifierSettings();
        }
        if (keyBindings[2].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.UNDO);
        }
        if (keyBindings[3].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.REDO);
        }
        if (keyBindings[4].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.PREVIOUS_BUILD_MODE);
        }
        if (keyBindings[5].consumeClick()) {
            ModeOptions.performAction((Player)player, ModeOptions.ActionEnum.DISABLE_BUILD_MODE_TOGGLE);
        }
    }

    public static void openModifierSettings() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (AttachmentHandler.isDisabled((Player)player)) {
            EffortlessBuilding.log((Player)player, "Build modifiers are disabled until your power level has increased. Increase your power level by consuming certain items.");
        } else {
            mc.setScreen((Screen)new ModifiersScreen());
        }
    }

    public static void openPlayerSettings() {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new PlayerSettingsGui());
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Opening event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            EffortlessBuildingClient.BUILDER_CHAIN.cancel();
        }
    }

    public static boolean isKeybindDown(int keybindIndex) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyBindings[keybindIndex].getKey().getValue());
    }

    public static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }

    static {
        ticksInGame = 0;
        placeCooldown = 0;
        breakCooldown = 0;
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            keyBindings = new KeyMapping[6];
            ClientEvents.keyBindings[0] = new KeyMapping("key.effortlessbuilding.mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.getKey((int)342, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[1] = new KeyMapping("key.effortlessbuilding.hud.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.getKey((int)334, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[2] = new KeyMapping("key.effortlessbuilding.undo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.getKey((int)90, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[3] = new KeyMapping("key.effortlessbuilding.redo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.getKey((int)89, (int)0), "key.effortlessbuilding.category");
            ClientEvents.keyBindings[4] = new KeyMapping("key.effortlessbuilding.previous_build_mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "key.effortlessbuilding.category");
            ClientEvents.keyBindings[5] = new KeyMapping("key.effortlessbuilding.disable_build_mode_toggle.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "key.effortlessbuilding.category");
            for (KeyMapping keyBinding : keyBindings) {
                event.register(keyBinding);
            }
        }
    }
}

