/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Palette
implements Set<PaletteColor> {
    public static final float BASE_TOLERANCE = 0.005882353f;
    private float tolerance = 0.0f;
    private final ArrayList<PaletteColor> internal = new ArrayList();

    protected Palette(Collection<PaletteColor> colors) {
        this.internal.addAll(colors);
        this.sort();
    }

    protected Palette(Collection<PaletteColor> colors, float tolerance) {
        this.internal.addAll(colors);
        this.sort();
        this.updateTolerance(tolerance);
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    public Palette copy() {
        return new Palette(new ArrayList<PaletteColor>(this.internal), this.tolerance);
    }

    public static Palette empty() {
        return new Palette(new ArrayList<PaletteColor>());
    }

    public void updateTolerance(float tolerance) {
        boolean recalculate;
        if (this.tolerance == tolerance) {
            return;
        }
        this.tolerance = tolerance;
        if (tolerance == 0.0f) {
            return;
        }
        do {
            recalculate = false;
            for (int i = 1; i < this.size(); ++i) {
                PaletteColor c1;
                PaletteColor c0 = this.get(i - 1);
                if (!(c0.distanceTo(c1 = this.get(i)) <= tolerance)) continue;
                Palette tempPal = new Palette(List.of(c0, c1));
                for (int after = i + 1; after < this.size() && tempPal.calculateAverage().distanceTo(this.get(after)) <= tolerance; ++after) {
                    tempPal.addUnchecked(this.get(after));
                }
                tempPal.getValues().forEach(this::remove);
                this.addUnchecked(tempPal.calculateAverage());
                recalculate = true;
            }
        } while (recalculate);
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    public List<PaletteColor> getValues() {
        return this.internal;
    }

    private void sort() {
        Collections.sort(this.internal);
    }

    private void addUnchecked(PaletteColor color) {
        if (color.rgb().alpha() == 0.0f) {
            return;
        }
        this.internal.add(color);
        this.sort();
    }

    @Override
    public boolean add(PaletteColor color) {
        if (color.rgb().alpha() == 0.0f) {
            return false;
        }
        if (!this.hasColor(color)) {
            this.internal.add(color);
            this.sort();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends PaletteColor> colors) {
        boolean added = false;
        for (PaletteColor paletteColor : colors) {
            if (this.hasColor(paletteColor)) continue;
            this.internal.add(paletteColor);
            added = true;
        }
        if (added) {
            this.sort();
            return true;
        }
        return false;
    }

    public void set(int index, PaletteColor color) {
        if (color.rgb().alpha() == 0.0f) {
            return;
        }
        if (!this.hasColor(color)) {
            this.internal.set(index, color);
        }
    }

    public PaletteColor get(int index) {
        return this.internal.get(index);
    }

    public int indexOf(PaletteColor color) {
        return this.internal.indexOf(color);
    }

    public boolean hasColor(int rgba) {
        return this.hasColor(new PaletteColor(rgba), 0.0f);
    }

    public boolean hasColor(PaletteColor color) {
        return this.hasColor(color, this.tolerance);
    }

    public boolean hasColor(PaletteColor color, float tolerance) {
        if (color.rgb().alpha() != 0.0f) {
            for (PaletteColor c : this.getValues()) {
                if (!(tolerance == 0.0f ? c.value() == color.value() : c.distanceTo(color) <= tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public PaletteColor getDarkest() {
        return this.getDarkest(0);
    }

    public PaletteColor getDarkest(int offset) {
        return this.get(offset);
    }

    public PaletteColor getLightest() {
        return this.getLightest(0);
    }

    public PaletteColor getLightest(int offset) {
        return this.get(this.internal.size() - 1 - offset);
    }

    public PaletteColor remove(int index) {
        return this.internal.remove(index);
    }

    public boolean remove(PaletteColor color) {
        return this.internal.remove(color);
    }

    @Override
    public boolean remove(Object o) {
        return this.internal.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> colors) {
        if (this.internal.removeAll(colors)) {
            this.sort();
            return true;
        }
        return false;
    }

    public PaletteColor calculateAverage() {
        return new PaletteColor(LABColor.averageColors((LABColor[])this.getValues().stream().map(PaletteColor::lab).toArray(LABColor[]::new)));
    }

    public PaletteColor getColorAtSlope(float slope) {
        int index = Math.round((float)(this.internal.size() - 1) * slope);
        return this.internal.get(index);
    }

    public PaletteColor getCenterColor() {
        PaletteColor center = this.calculateAverage();
        return this.getColorClosestTo(center);
    }

    public PaletteColor getColorClosestTo(PaletteColor target) {
        PaletteColor bestMatch = target;
        float lastDist = Float.MAX_VALUE;
        for (PaletteColor c : this.getValues()) {
            float dist = target.distanceTo(c);
            if (!(dist < lastDist)) continue;
            lastDist = dist;
            bestMatch = c;
        }
        return bestMatch;
    }

    public void matchSize(int targetSize) {
        this.matchSize(targetSize, null);
    }

    public void matchSize(int targetSize, @Nullable Float targetLumStep) {
        int currentSize;
        if (targetLumStep != null && (float)(targetSize - 1) * targetLumStep.floatValue() > 1.0f) {
            throw new UnsupportedOperationException("Palette (size-1) * luminance step must be less than 1");
        }
        if (targetLumStep != null && targetLumStep.floatValue() < 0.0f) {
            throw new UnsupportedOperationException("Luminance step must be positive");
        }
        if (this.size() == 0 || targetSize <= 0) {
            throw new UnsupportedOperationException("Palette size can't be 0");
        }
        if (targetLumStep != null) {
            targetLumStep = Float.valueOf(targetLumStep.floatValue() - 1.0E-5f);
        }
        if (this.size() == 1) {
            PaletteColor first = this.get(0);
            this.add(first.getDarkened());
            this.add(first.getLightened());
        }
        if (this.size() == 2 && targetLumStep == null) {
            PaletteColor lightest = this.getLightest();
            PaletteColor darkest = this.getDarkest();
            Palette other = Palette.fromArc(lightest.hcl(), darkest.hcl(), targetSize);
            this.internal.clear();
            this.internal.addAll(other.getValues());
        }
        while (this.size() > targetSize) {
            if (this.size() > 14) {
                this.removeLeastUsed();
                continue;
            }
            this.reduceAndAverage();
        }
        boolean down = true;
        boolean canIncreaseDown = true;
        boolean canIncreaseUp = true;
        while ((currentSize = this.size()) < targetSize) {
            if (!canIncreaseDown && !canIncreaseUp || !this.shouldExpandRange(targetSize, targetLumStep)) {
                this.increaseInner();
                continue;
            }
            if (down) {
                this.increaseDown();
            } else {
                this.increaseUp();
            }
            if (currentSize == this.size()) {
                if (down) {
                    canIncreaseDown = false;
                } else {
                    canIncreaseUp = false;
                }
                boolean bl = down = !down;
            }
            if (!canIncreaseDown || !canIncreaseUp) continue;
            down = !down;
        }
    }

    private boolean shouldExpandRange(int targetSize, @Nullable Float targetStep) {
        if (targetStep == null) {
            return false;
        }
        float targetRange = (float)targetSize * targetStep.floatValue();
        float currentRange = this.getLuminanceSpan();
        return currentRange < targetRange;
    }

    public PaletteColor removeLeastUsed() {
        PaletteColor toRemove = this.internal.get(0);
        for (PaletteColor p : this.internal) {
            if (p.getOccurrence() >= toRemove.getOccurrence()) continue;
            toRemove = p;
        }
        this.remove(toRemove);
        return toRemove;
    }

    public PaletteColor reduce() {
        int index = 0;
        float minDelta = 10000.0f;
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            float dl = l - lastLum;
            if (dl < minDelta) {
                index = i;
                minDelta = dl;
            }
            lastLum = l;
        }
        return this.remove(index);
    }

    public PaletteColor reduceAndAverage() {
        int index = 0;
        float minDelta = 10000.0f;
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            float dl = l - lastLum;
            if (dl < minDelta) {
                index = i;
                minDelta = dl;
            }
            lastLum = l;
        }
        PaletteColor toRemove = this.get(index);
        PaletteColor toRemove2 = this.get(index - 1);
        this.remove(toRemove);
        this.remove(toRemove2);
        PaletteColor newColor = new PaletteColor(toRemove.lab().mixWith(toRemove2.lab()));
        newColor.setOccurrence(toRemove.getOccurrence() * toRemove2.getOccurrence());
        this.add(newColor);
        return newColor;
    }

    public void changeSizeMatchingLuminanceSpan(float targetLuminanceSpan) {
        if (targetLuminanceSpan > 1.0f || targetLuminanceSpan < 0.0f) {
            throw new UnsupportedOperationException("Luminance span must be between 0 and 1");
        }
        float currentSpan = this.getLuminanceSpan();
        while ((double)Mth.abs((float)(currentSpan - targetLuminanceSpan)) > 0.5 * (double)this.getAverageLuminanceStep()) {
            if (currentSpan < targetLuminanceSpan) {
                if (this.getLightest().luminance() < 1.0f - this.getDarkest().luminance()) {
                    this.increaseUp();
                } else {
                    this.increaseDown();
                }
            } else {
                if (!(currentSpan > targetLuminanceSpan)) break;
                if (this.getLightest().luminance() > 1.0f - this.getDarkest().luminance()) {
                    this.reduceUp();
                } else {
                    this.reduceDown();
                }
            }
            currentSpan = this.getLuminanceSpan();
        }
    }

    public void expandMatchingLuminanceRange(float minLuminance, float maxLuminance) {
        float currentMin = this.getDarkest().luminance();
        float currentMax = this.getLightest().luminance();
        while ((double)Mth.abs((float)(currentMin - minLuminance)) > 0.5 * (double)this.getAverageLuminanceStep()) {
            if (currentMin < minLuminance) {
                this.reduceDown();
            } else {
                this.increaseDown();
            }
            currentMin = this.getDarkest().luminance();
        }
        while ((double)Mth.abs((float)(currentMax - maxLuminance)) > 0.5 * (double)this.getAverageLuminanceStep()) {
            if (currentMax > maxLuminance) {
                this.reduceUp();
            } else {
                this.increaseUp();
            }
            currentMax = this.getLightest().luminance();
        }
    }

    public void matchLuminanceStep(float newLuminanceStep) {
        float centerLuminance = this.getCenterLuminance();
        int size = this.size();
        float lowerLuminance = centerLuminance - newLuminanceStep * (float)size / 2.0f;
        Palette copy = this.copy();
        for (int i = 0; i < size; ++i) {
            PaletteColor color = copy.get(i);
            float newLum = lowerLuminance + (float)i * newLuminanceStep;
            this.remove(color);
            this.addUnchecked(new PaletteColor(color.hcl().withLuminance(newLum)));
        }
    }

    private boolean hasLuminanceGap() {
        return this.hasLuminanceGap(1.7f);
    }

    private boolean hasLuminanceGap(float cutoff) {
        List<Float> list = this.getLuminanceSteps();
        float mean = this.getAverageLuminanceStep();
        for (Float s : list) {
            if (!(s.floatValue() > cutoff * mean)) continue;
            return true;
        }
        return false;
    }

    public float getLuminanceStepVariationCoeff() {
        List<Float> list = this.getLuminanceSteps();
        float mean = this.getAverageLuminanceStep();
        float sum = 0.0f;
        for (Float s : list) {
            sum += (s.floatValue() - mean) * (s.floatValue() - mean);
        }
        return Mth.sqrt((float)(sum / (float)(list.size() - 1))) / mean;
    }

    public List<Float> getLuminanceSteps() {
        ArrayList<Float> list = new ArrayList<Float>();
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            list.add(Float.valueOf(l - lastLum));
            lastLum = l;
        }
        return list;
    }

    public float getAverageLuminanceStep() {
        return this.getLuminanceSpan() / (float)(this.size() - 1);
    }

    public float getLuminanceSpan() {
        return this.getLightest().luminance() - this.getDarkest().luminance();
    }

    public float getCenterLuminance() {
        return (this.getLightest().luminance() + this.getDarkest().luminance()) / 2.0f;
    }

    public PaletteColor reduceUp() {
        PaletteColor c = this.getLightest();
        this.remove(c);
        return c;
    }

    public PaletteColor reduceDown() {
        PaletteColor c = this.getDarkest();
        this.remove(c);
        return c;
    }

    public PaletteColor increaseInner() {
        assert (this.size() < 2);
        int index = 1;
        float maxDelta = 0.0f;
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            float dl = l - lastLum;
            if (dl > maxDelta) {
                index = i;
                maxDelta = dl;
            }
            lastLum = l;
        }
        HCLColor c1 = this.get(index).hcl();
        HCLColor c2 = this.get(index - 1).hcl();
        PaletteColor newC = new PaletteColor(c1.mixWith(c2));
        this.addUnchecked(newC);
        return newC;
    }

    public PaletteColor increaseUp() {
        assert (this.size() < 2);
        float averageDeltaLum = this.getAverageLuminanceStep();
        HCLColor lightest = this.getLightest().hcl();
        HCLColor secondLightest = this.get(this.size() - 2).hcl();
        HCLColor cc = this.getNextColor(averageDeltaLum, lightest, secondLightest);
        PaletteColor pl = new PaletteColor(cc);
        this.addUnchecked(pl);
        return pl;
    }

    public PaletteColor increaseDown() {
        assert (this.size() < 2);
        float averageDeltaLum = this.getAverageLuminanceStep();
        HCLColor darkest = this.getDarkest().hcl();
        HCLColor secondDarkest = this.get(1).hcl();
        HCLColor cc = this.getNextColor(-averageDeltaLum, darkest, secondDarkest);
        PaletteColor pl = new PaletteColor(cc);
        this.addUnchecked(pl);
        return pl;
    }

    private HCLColor getNextColor(float lumIncrease, HCLColor source, HCLColor previous) {
        float newH;
        float newLum = source.luminance() + lumIncrease;
        float h1 = source.hue();
        float c1 = source.chroma();
        float a1 = source.alpha();
        float h2 = previous.hue();
        float c2 = previous.chroma();
        float a2 = previous.alpha();
        float hueIncrease = (float)((double)(-MthUtils.signedAngleDiff((double)h1 * Math.PI * 2.0, (double)h2 * Math.PI * 2.0)) / (Math.PI * 2));
        for (newH = h1 + hueIncrease * 0.5f; newH < 0.0f; newH += 1.0f) {
        }
        float newC = c1 + (c1 - c2);
        float newA = a1 + (a1 - a2);
        return new HCLColor(newH, newC, newLum, newA);
    }

    public static Palette merge(Palette ... palettes) {
        if (palettes.length == 1) {
            return new Palette(palettes[0].getValues());
        }
        HashMap<Integer, PaletteColor> map = new HashMap<Integer, PaletteColor>();
        for (Palette p : palettes) {
            for (PaletteColor c : p.getValues()) {
                int color = c.value();
                if (map.containsKey(color)) {
                    ((PaletteColor)map.get(color)).setOccurrence(((PaletteColor)map.get(color)).getOccurrence() + c.getOccurrence());
                    continue;
                }
                map.put(color, c);
            }
        }
        if (map.values().size() == 0) {
            return new Palette(new ArrayList<PaletteColor>());
        }
        return new Palette(map.values());
    }

    public static <C extends BaseColor<C>> Palette ofColors(Collection<C> colors) {
        return new Palette(colors.stream().map(PaletteColor::new).collect(Collectors.toSet()));
    }

    public static <T extends BaseColor<T>> Palette fromArc(T light, T dark, int size) {
        ArrayList<T> colors = new ArrayList<T>();
        if (size <= 1) {
            throw new IllegalArgumentException("Size must be greater than one");
        }
        for (int i = 0; i < size; ++i) {
            colors.add(dark.mixWith(light, (float)i / ((float)size - 1.0f)));
        }
        return new Palette(colors.stream().map(PaletteColor::new).collect(Collectors.toSet()));
    }

    public static Palette fromImage(TextureImage image) {
        return Palette.fromImage(image, null);
    }

    public static Palette fromImage(TextureImage image, @Nullable TextureImage mask) {
        return Palette.fromImage(image, mask, 0.005882353f);
    }

    public static Palette fromImage(TextureImage textureImage, @Nullable TextureImage textureMask, float tolerance) {
        List<Palette> palettes = Palette.fromAnimatedImage(textureImage, textureMask, 0.0f);
        Palette palette = Palette.merge(palettes.toArray(new Palette[0]));
        if (tolerance != 0.0f) {
            palette.updateTolerance(tolerance);
        }
        if (palette.isEmpty()) {
            Moonlight.LOGGER.error("Palette from image {} ended up being empty", (Object)textureImage);
        }
        return palette;
    }

    public static List<Palette> fromAnimatedImage(TextureImage image) {
        return Palette.fromAnimatedImage(image, null);
    }

    public static List<Palette> fromAnimatedImage(TextureImage image, @Nullable TextureImage mask) {
        return Palette.fromAnimatedImage(image, mask, 0.005882353f);
    }

    public static List<Palette> fromAnimatedImage(TextureImage textureImage, @Nullable TextureImage textureMask, float tolerance) {
        if (textureMask != null && (textureImage.frameCount() != textureMask.frameCount() || textureMask.frameWidth() < textureImage.frameWidth() || textureMask.frameHeight() < textureImage.frameHeight())) {
            throw new UnsupportedOperationException("Palette mask needs to be at least as large as the target image and have the same format");
        }
        ArrayList<Palette> palettes = new ArrayList<Palette>();
        NativeImage mask = textureMask == null ? null : textureMask.getImage();
        NativeImage image = textureImage.getImage();
        ArrayList paletteBuilders = new ArrayList();
        textureImage.forEachFramePixel((index, x, y) -> {
            int color;
            if (paletteBuilders.size() <= index) {
                paletteBuilders.add(new HashMap());
            }
            Map builder = (Map)paletteBuilders.get(index);
            if ((mask == null || FastColor.ABGR32.alpha((int)mask.getPixelRGBA(x.intValue(), y.intValue())) == 0) && FastColor.ABGR32.alpha((int)(color = image.getPixelRGBA(x.intValue(), y.intValue()))) != 0) {
                PaletteColor paletteColor = builder.computeIfAbsent(color, p -> new PaletteColor(color));
                paletteColor.setOccurrence(paletteColor.getOccurrence() + 1);
            }
        });
        for (Map p : paletteBuilders) {
            Palette pal = p.size() == 0 ? new Palette(new ArrayList<PaletteColor>()) : new Palette(p.values(), tolerance);
            palettes.add(pal);
        }
        return palettes;
    }

    @Override
    @NotNull
    public Iterator<PaletteColor> iterator() {
        return new ItrWrapper();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.internal.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.internal.toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.internal.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean contains(Object o) {
        return this.internal.contains(o);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (this.internal.retainAll(c)) {
            this.sort();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    private class ItrWrapper
    implements Iterator<PaletteColor> {
        private final Iterator<PaletteColor> itr;

        private ItrWrapper() {
            this.itr = Palette.this.internal.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public PaletteColor next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            this.itr.remove();
            Palette.this.sort();
        }
    }
}

