/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.integration.ModernFixCompat;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements PackResources {
    private static final List<DynamicResourcePack> INSTANCES = Collections.synchronizedList(new ArrayList());
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final PackLocationInfo locationInfo;
    protected final ResourceLocation resourcePackName;
    protected final boolean hidden;
    protected final boolean fixed;
    protected final Pack.Position position;
    protected final PackType packType;
    protected final Supplier<PackMetadataSection> metadata;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<ResourceLocation, byte[]> resources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    protected boolean clearOnReload = true;
    protected Set<ResourceLocation> staticResources = new HashSet<ResourceLocation>();
    protected boolean generateDebugResources;
    boolean addToStatic = false;
    private boolean needsClearingNonStatic = false;
    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    @ApiStatus.Internal
    public static void clearAfterReload(PackType targetType) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType != targetType) continue;
            p.clearNonStatic();
        }
    }

    @ApiStatus.Internal
    public static void clearBeforeReload(PackType targetType) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType != targetType) continue;
            p.clearAllContent();
        }
    }

    protected DynamicResourcePack(ResourceLocation name, PackType type) {
        this(name, type, Pack.Position.TOP, false, false);
    }

    protected DynamicResourcePack(ResourceLocation name, PackType type, Pack.Position position, boolean fixed, boolean hidden) {
        this.locationInfo = new PackLocationInfo(name.toString(), (Component)Component.translatable((String)LangBuilder.getReadableName(name.toString())), PackSource.BUILT_IN, Optional.empty());
        this.packType = type;
        this.resourcePackName = name;
        this.mainNamespace = name.getNamespace();
        this.namespaces.add(this.mainNamespace);
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.metadata = Suppliers.memoize(() -> new PackMetadataSection(this.makeDescription(), SharedConstants.getCurrentVersion().getPackVersion(type), Optional.empty()));
        this.generateDebugResources = PlatHelper.isDev();
    }

    public PackLocationInfo location() {
        return this.locationInfo;
    }

    public Component makeDescription() {
        return Component.translatable((String)LangBuilder.getReadableName(this.mainNamespace + "_dynamic_resources"));
    }

    public void setClearOnReload(boolean canBeCleared) {
        this.clearOnReload = canBeCleared;
    }

    public void markNotClearable(ResourceLocation texturePath) {
        this.staticResources.add(texturePath);
    }

    public void unMarkNotClearable(ResourceLocation staticResources) {
        this.staticResources.remove(staticResources);
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public ResourceLocation id() {
        return this.resourcePackName;
    }

    public String toString() {
        return this.packId();
    }

    public Component getTitle() {
        return this.location().title();
    }

    public void registerPack() {
        if (!INSTANCES.contains(this)) {
            PlatHelper.registerResourcePack(this.packType, () -> Pack.readMetaAndCreate((PackLocationInfo)this.locationInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo location) {
                    return DynamicResourcePack.this;
                }

                public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                    return DynamicResourcePack.this;
                }
            }, (PackType)this.packType, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false)));
            INSTANCES.add(this);
        }
    }

    public Set<String> getNamespaces(PackType packType) {
        return this.namespaces;
    }

    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) {
        try {
            return (T)(serializer == PackMetadataSection.TYPE ? this.metadata.get() : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    public void listResources(PackType packType, String namespace, String id, PackResources.ResourceOutput output) {
        if (packType == this.packType) {
            this.searchTrie.search(namespace + "/" + id).forEach(r -> {
                byte[] buf = this.resources.get(r);
                output.accept(r, () -> {
                    if (buf == null) {
                        throw new IllegalStateException("Somehow search tree returned a resource not in resources " + String.valueOf(r));
                    }
                    return new ByteArrayInputStream(buf);
                });
            });
        }
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(ResourceLocation id, byte[] bytes) {
        this.namespaces.add(id.getNamespace());
        this.resources.put(id, bytes);
        this.searchTrie.insert(id);
        if (this.addToStatic) {
            this.markNotClearable(id);
        }
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(id.getNamespace() + "/" + id.getPath());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeResource(ResourceLocation res) {
        this.searchTrie.remove(res);
        this.resources.remove(res);
        this.staticResources.remove(res);
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(ResourceLocation path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addJson(ResourceLocation location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(ResourceLocation location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public PackType getPackType() {
        return this.packType;
    }

    @ApiStatus.Internal
    protected void clearNonStatic() {
        boolean mf;
        if (!CommonConfigs.CLEAR_RESOURCES.get().booleanValue()) {
            return;
        }
        if (!this.needsClearingNonStatic) {
            return;
        }
        this.needsClearingNonStatic = false;
        boolean bl = mf = MODERN_FIX && this.getPackType() == PackType.CLIENT_RESOURCES;
        if (!mf) {
            this.searchTrie.clear();
        }
        for (ResourceLocation resourceLocation : this.resources.keySet()) {
            if (mf && this.modernFixHack(resourceLocation.getPath()) || this.staticResources.contains(resourceLocation)) continue;
            this.resources.remove(resourceLocation);
        }
        if (mf) {
            ArrayList<CallSite> toRemove = new ArrayList<CallSite>();
            for (String namespace : this.searchTrie.listFolders("")) {
                for (String f : this.searchTrie.listFolders(namespace)) {
                    if (this.modernFixHack(f)) continue;
                    toRemove.add((CallSite)((Object)(namespace + "/" + f)));
                }
            }
            toRemove.forEach(this.searchTrie::remove);
        }
        for (ResourceLocation resourceLocation : this.staticResources) {
            this.searchTrie.insert(resourceLocation);
        }
    }

    @ApiStatus.Internal
    protected void clearAllContent() {
        if (this.clearOnReload) {
            this.searchTrie.clear();
            this.resources.clear();
            this.needsClearingNonStatic = true;
        }
    }

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }
}

