/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public interface IRenderedTankUpgrade {
    public void setTankRenderInfoUpdateCallback(Consumer<TankRenderInfo> var1);

    public void forceUpdateTankRenderInfo();

    public static class TankRenderInfo {
        private static final String FLUID_TAG = "fluid";
        private static final String FILL_RATIO_TAG = "fillRatio";
        @Nullable
        private FluidStack fluidStack;
        private float fillRatio;

        public TankRenderInfo() {
            this(null, 0.0f);
        }

        public TankRenderInfo(@Nullable FluidStack fluidStack, float fillRatio) {
            this.fluidStack = fluidStack;
            this.fillRatio = fillRatio;
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (this.fluidStack != null) {
                ret.put(FLUID_TAG, RegistryHelper.getRegistryAccess().map(registryAccess -> this.fluidStack.saveOptional((HolderLookup.Provider)registryAccess)).orElse((Tag)new CompoundTag()));
                ret.putFloat(FILL_RATIO_TAG, this.fillRatio);
            }
            return ret;
        }

        public static TankRenderInfo deserialize(CompoundTag tag) {
            FluidStack fluidStack;
            if (tag.contains(FLUID_TAG) && !(fluidStack = RegistryHelper.getRegistryAccess().map(registryAccess -> FluidStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)tag.getCompound(FLUID_TAG))).orElse(FluidStack.EMPTY)).isEmpty()) {
                return new TankRenderInfo(fluidStack, tag.getFloat(FILL_RATIO_TAG));
            }
            return new TankRenderInfo();
        }

        public void setFluid(FluidStack fluidStack) {
            this.fluidStack = fluidStack.copy();
        }

        public Optional<FluidStack> getFluid() {
            return Optional.ofNullable(this.fluidStack);
        }

        public void setFillRatio(float fillRatio) {
            this.fillRatio = fillRatio;
        }

        public float getFillRatio() {
            return this.fillRatio;
        }
    }
}

