/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei.subtypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyBasedSubtypeInterpreter
implements ISubtypeInterpreter<ItemStack> {
    private final List<IPropertyDefinition<?>> propertyDefinitions = new ArrayList();

    protected <T> void addOptionalProperty(Function<ItemStack, Optional<T>> propertyGetter, String propertyName, Function<T, String> propertyValueSerializer) {
        Function<ItemStack, @Nullable Object> nullableGetter = propertyGetter.andThen(i -> i.orElse(null));
        this.addDefinition(nullableGetter, propertyName, propertyValueSerializer);
    }

    private <T> void addDefinition(final Function<ItemStack, @Nullable T> getter, final String propertyName, final Function<T, String> propertyValueSerializer) {
        this.propertyDefinitions.add(new IPropertyDefinition<T>(){

            @Override
            @Nullable
            public T getPropertyValue(ItemStack itemStack) {
                return getter.apply(itemStack);
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }

            @Override
            public String serializePropertyValue(@Nullable T property) {
                return property != null ? (String)propertyValueSerializer.apply(property) : "";
            }
        });
    }

    protected <T> void addProperty(Function<ItemStack, @Nullable T> propertyGetter, String propertyName, Function<T, String> propertyValueSerializer) {
        this.addDefinition(propertyGetter, propertyName, propertyValueSerializer);
    }

    @Nullable
    public final Object getSubtypeData(ItemStack ingredient, UidContext context) {
        boolean allNulls = true;
        ArrayList<@Nullable ?> results = new ArrayList(this.propertyDefinitions.size());
        for (IPropertyDefinition<?> definition : this.propertyDefinitions) {
            @Nullable ? value = definition.getPropertyValue(ingredient);
            if (value != null) {
                allNulls = false;
            }
            results.add(value);
        }
        if (allNulls) {
            return null;
        }
        return results;
    }

    public String getLegacyStringSubtypeInfo(ItemStack itemStack, UidContext context) {
        StringBuilder result = new StringBuilder();
        for (IPropertyDefinition<?> definition : this.propertyDefinitions) {
            @Nullable ? value = definition.getPropertyValue(itemStack);
            if (value == null) continue;
            String serializedValue = this.getSerializedPropertyValue(definition, value);
            if (!result.isEmpty()) {
                result.append(',');
            }
            result.append(definition.getPropertyName()).append(':').append(serializedValue);
        }
        return "{" + String.valueOf(result) + "}";
    }

    private <T> String getSerializedPropertyValue(IPropertyDefinition<T> definition, Object value) {
        return definition.serializePropertyValue(value);
    }

    public String getRegistrySanitizedItemString(ItemStack stack) {
        StringBuilder result = new StringBuilder();
        for (IPropertyDefinition<?> definition : this.propertyDefinitions) {
            @Nullable ? value = definition.getPropertyValue(stack);
            if (value == null) continue;
            String serializedValue = this.sanitize(this.getSerializedPropertyValue(definition, value));
            if (!result.isEmpty()) {
                result.append('_');
            }
            result.append(definition.getPropertyName().toLowerCase(Locale.ROOT)).append('_').append(serializedValue);
        }
        return PropertyBasedSubtypeInterpreter.getItemPath(stack) + "_" + String.valueOf(result);
    }

    private String sanitize(String value) {
        return value.replaceAll(":", "_").toLowerCase(Locale.ROOT);
    }

    @NotNull
    private static String getItemPath(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
    }

    public static interface IPropertyDefinition<T> {
        @Nullable
        public T getPropertyValue(ItemStack var1);

        public String getPropertyName();

        public String serializePropertyValue(@Nullable T var1);
    }
}

