/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;

public record OpenMountedStorageInventoryPayload(int contraptionEntityId, BlockPos localPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenMountedStorageInventoryPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("open_mounted_storage_inventory"));
    public static final StreamCodec<ByteBuf, OpenMountedStorageInventoryPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, OpenMountedStorageInventoryPayload::contraptionEntityId, (StreamCodec)BlockPos.STREAM_CODEC, OpenMountedStorageInventoryPayload::localPos, OpenMountedStorageInventoryPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(OpenMountedStorageInventoryPayload payload, IPayloadContext context) {
        AbstractContraptionEntity contraptionEntity;
        MountedStorageBase storage;
        Player player = context.player();
        Entity entity = player.level().getEntity(payload.contraptionEntityId());
        if (entity instanceof AbstractContraptionEntity && (storage = ContraptionHelper.getMountedStorage(contraptionEntity = (AbstractContraptionEntity)entity, payload.localPos())) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            storage.openMenu(serverPlayer, contraptionEntity.getId(), payload.localPos());
        }
    }
}

