/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContentsPayload;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public abstract class MountedStorageSettingsContainerMenuBase
extends SettingsContainerMenu<IStorageWrapper> {
    private final int contraptionEntityId;
    private final BlockPos localPos;
    private CompoundTag lastSettingsNbt = null;

    public MountedStorageSettingsContainerMenuBase(MenuType<?> menuType, int windowId, Player player, int contraptionEntityId, BlockPos localPos) {
        super(menuType, windowId, player, MountedStorageSettingsContainerMenuBase.getWrapper(player.level(), contraptionEntityId, localPos));
        this.contraptionEntityId = contraptionEntityId;
        this.localPos = localPos;
    }

    private static IStorageWrapper getWrapper(Level level, int contraptionEntityId, BlockPos localPos) {
        Entity entity = level.getEntity(contraptionEntityId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        MountedStorageBase itemStorage = ContraptionHelper.getMountedStorage(contraptionEntity, localPos);
        if (itemStorage == null) {
            return NoopStorageWrapper.INSTANCE;
        }
        return itemStorage.getStorageWrapper();
    }

    @Override
    public void detectSettingsChangeAndReload() {
        if (this.player.level().isClientSide) {
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                MountedStorageData storage = MountedStorageData.get(uuid);
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    CompoundTag contents = storage.getContents();
                    this.storageWrapper.getSettingsHandler().reloadFrom(this.getSettingsTag(contents));
                }
            });
        }
    }

    protected abstract CompoundTag getSettingsTag(CompoundTag var1);

    public int getContraptionEntityId() {
        return this.contraptionEntityId;
    }

    private void sendStorageSettingsToClient() {
        if (this.player.level().isClientSide) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().copy();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.isEmpty()) {
                    settingsContents.put("settings", (Tag)settingsNbt);
                    Player patt0$temp = this.player;
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MountedStorageContentsPayload((UUID)uuid, settingsContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            });
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        this.sendStorageSettingsToClient();
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.localPos;
    }
}

