/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.bindings.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class SizedIngredientComponent
implements RecipeComponent<SizedIngredient> {
    public static final SizedIngredientComponent FLAT = new SizedIngredientComponent("flat_sized_ingredient", (Codec<SizedIngredient>)SizedIngredient.FLAT_CODEC);
    public static final SizedIngredientComponent NESTED = new SizedIngredientComponent("nested_sized_ingredient", (Codec<SizedIngredient>)SizedIngredient.NESTED_CODEC);
    public final String name;
    public final Codec<SizedIngredient> codec;

    public SizedIngredientComponent(String name, Codec<SizedIngredient> codec) {
        this.name = name;
        this.codec = codec;
    }

    @Override
    public Codec<SizedIngredient> codec() {
        return this.codec;
    }

    @Override
    public TypeInfo typeInfo() {
        return SizedIngredientWrapper.TYPE_INFO;
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        return from instanceof SizedIngredient || IngredientJS.isIngredientLike(from);
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, SizedIngredient value, ReplacementMatchInfo match) {
        ItemMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof ItemMatch && (m = (ItemMatch)replacementMatch).matches(cx, value.ingredient(), match.exact());
    }

    @Override
    public boolean isEmpty(SizedIngredient value) {
        return value.count() <= 0 || value.ingredient().isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, SizedIngredient value) {
        TagKey<Item> tag = IngredientWrapper.tagKeyOf(value.ingredient());
        if (tag != null) {
            builder.append(tag.location());
        } else {
            ItemStack first = value.ingredient().kjs$getFirst();
            if (!first.isEmpty()) {
                builder.append(first.kjs$getIdLocation());
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

