/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.neoforge;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.neoforge.NativeEventListeners;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.Context;
import java.util.function.Consumer;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.common.NeoForge;

public interface NativeEventWrapper {
    public static void onEvent(Context cx, Class<?> eventClass, Consumer<Event> consumer) {
        NativeEventWrapper.onEvent(cx, EventPriority.NORMAL, eventClass, consumer);
    }

    public static void onEvent(Context cx, EventPriority priority, Class<?> eventClass, Consumer<Event> consumer) {
        if (!Event.class.isAssignableFrom(eventClass)) {
            throw new IllegalArgumentException("Event class must extend net.neoforged.bus.api.Event!");
        }
        ScriptType scriptType = ((KubeJSContext)cx).kjsFactory.manager.scriptType;
        NativeEventListeners.Key key = new NativeEventListeners.Key(eventClass, priority == null ? EventPriority.NORMAL : priority);
        NativeEventListeners listeners = scriptType.nativeEventListeners.get(key);
        if (listeners == null) {
            listeners = new NativeEventListeners();
            scriptType.nativeEventListeners.put(key, listeners);
            IEventBus bus = IModBusEvent.class.isAssignableFrom(eventClass) ? KubeJS.modEventBus : NeoForge.EVENT_BUS;
            bus.addListener(priority, false, eventClass, (Consumer)listeners);
        }
        listeners.listeners.add(consumer);
    }
}

