/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.bindings.ColorWrapper;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.type.TypeInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ItemTintFunction {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(ItemTintFunction.class);
    public static final ItemTintFunction BLOCK = (stack, index) -> {
        BlockItem block;
        BlockState s;
        BlockBuilder internal;
        Item patt0$temp = stack.getItem();
        if (patt0$temp instanceof BlockItem && (internal = (s = (block = (BlockItem)patt0$temp).getBlock().defaultBlockState()).getBlock().kjs$getBlockBuilder()) != null && internal.tint != null) {
            return internal.tint.getColor(s, null, null, index);
        }
        return null;
    };
    public static final ItemTintFunction POTION = (stack, index) -> {
        PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potion != null) {
            return new SimpleColor(potion.getColor());
        }
        return null;
    };
    public static final ItemTintFunction MAP = (stack, index) -> {
        MapItemColor map = (MapItemColor)stack.get(DataComponents.MAP_COLOR);
        if (map != null) {
            return new SimpleColor(map.rgb());
        }
        return null;
    };
    public static final ItemTintFunction DISPLAY_COLOR_NBT = (stack, index) -> {
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (color != null) {
            return new SimpleColor(color.rgb());
        }
        return null;
    };

    public KubeColor getColor(ItemStack var1, int var2);

    @Nullable
    public static ItemTintFunction of(Context cx, Object o) {
        if (o == null || Undefined.isUndefined((Object)o)) {
            return null;
        }
        if (o instanceof ItemTintFunction) {
            ItemTintFunction f = (ItemTintFunction)o;
            return f;
        }
        if (o instanceof List) {
            List list = (List)o;
            Mapped map = new Mapped();
            for (int i = 0; i < list.size(); ++i) {
                ItemTintFunction f = ItemTintFunction.of(cx, list.get(i));
                if (f == null) continue;
                map.map.put(i, (Object)f);
            }
            return map;
        }
        if (o instanceof CharSequence) {
            ItemTintFunction f;
            switch (o.toString()) {
                case "block": {
                    ItemTintFunction itemTintFunction = BLOCK;
                    break;
                }
                case "potion": {
                    ItemTintFunction itemTintFunction = POTION;
                    break;
                }
                case "map": {
                    ItemTintFunction itemTintFunction = MAP;
                    break;
                }
                case "display_color_nbt": {
                    ItemTintFunction itemTintFunction = DISPLAY_COLOR_NBT;
                    break;
                }
                default: {
                    ItemTintFunction itemTintFunction = f = null;
                }
            }
            if (f != null) {
                return f;
            }
        } else if (o instanceof BaseFunction) {
            BaseFunction function = (BaseFunction)o;
            return (ItemTintFunction)cx.createInterfaceAdapter(TYPE_INFO, (ScriptableObject)function);
        }
        return new Fixed(ColorWrapper.of(o));
    }

    public static class Mapped
    implements ItemTintFunction {
        public final Int2ObjectMap<ItemTintFunction> map = new Int2ObjectArrayMap(1);

        @Override
        public KubeColor getColor(ItemStack stack, int index) {
            ItemTintFunction f = (ItemTintFunction)this.map.get(index);
            return f == null ? null : f.getColor(stack, index);
        }
    }

    public record Fixed(KubeColor color) implements ItemTintFunction
    {
        @Override
        public KubeColor getColor(ItemStack stack, int index) {
            return this.color;
        }
    }
}

