/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.gui;

import dev.latvian.mods.kubejs.gui.InventoryKJSSlot;
import dev.latvian.mods.kubejs.gui.KubeJSGUI;
import dev.latvian.mods.kubejs.gui.KubeJSMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.IContainerFactory;

public class KubeJSMenu
extends AbstractContainerMenu {
    public static final IContainerFactory<KubeJSMenu> FACTORY = KubeJSMenu::new;
    public final Player player;
    public final KubeJSGUI guiData;

    public KubeJSMenu(int id, Inventory inventory, KubeJSGUI guiData) {
        super(KubeJSMenus.MENU.get(), id);
        this.player = inventory.player;
        this.guiData = guiData;
        if (guiData.inventory.kjs$getSlots() > 0) {
            int m;
            int l;
            int k = (guiData.inventoryHeight - 4) * 18;
            for (l = 0; l < guiData.inventoryHeight; ++l) {
                for (m = 0; m < 9; ++m) {
                    this.addSlot(new InventoryKJSSlot(guiData.inventory, m + l * 9, 8 + m * 18, 18 + l * 18));
                }
            }
            if (guiData.playerSlotsX >= 0 && guiData.playerSlotsY >= 0) {
                for (l = 0; l < 3; ++l) {
                    for (m = 0; m < 9; ++m) {
                        this.addSlot(new Slot((Container)inventory, m + l * 9 + 9, guiData.playerSlotsX + m * 18, guiData.playerSlotsY + l * 18 + k));
                    }
                }
                for (l = 0; l < 9; ++l) {
                    this.addSlot(new Slot((Container)inventory, l, guiData.playerSlotsX + l * 18, guiData.playerSlotsY + 58 + k));
                }
            }
        }
    }

    public KubeJSMenu(int id, Inventory inventory, FriendlyByteBuf buf) {
        this(id, inventory, new KubeJSGUI(buf));
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        int slotCount = this.guiData.inventory.kjs$getSlots();
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (i < slotCount ? !this.moveItemStackTo(itemStack2, slotCount, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

