/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.modules;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.ItemLightLevels;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerSelfLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private LightConfig config;
    private final HashMap<Player, PlayerLightSourceContainer> playerLightsMap = new HashMap();

    public PlayerSelfLightSource() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverStartEvent(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        LightConfig defaultConfig = new LightConfig();
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.TORCH), 14, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.LANTERN), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.CAMPFIRE), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.GLOWSTONE), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), 10, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.REDSTONE_ORE), 10, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.REDSTONE_BLOCK), 10, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_LANTERN), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_TORCH), 14, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.TORCH), 0, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_TORCH), 0, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.CAMPFIRE), 0, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE), 0, (RegistryAccess)registryAccess));
        File configFile = server.getServerDirectory().resolve("config" + File.separatorChar + "dynamiclights_selflight.cfg").toFile();
        try {
            this.config = GsonConfig.loadConfigWithDefault(LightConfig.class, configFile, defaultConfig);
            if (this.config == null) {
                throw new UnsupportedOperationException("PlayerSelfLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(this.config.getItemsList(), LOGGER, (RegistryAccess)registryAccess);
            notWaterProofItems = new ItemConfigHelper(this.config.getNotWaterProofList(), LOGGER, (RegistryAccess)registryAccess);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (player.isAlive()) {
            PlayerLightSourceContainer playerLightSourceContainer = this.playerLightsMap.get(player);
            if (playerLightSourceContainer == null) {
                LOGGER.trace("built new PlayerLightSourceContainer for player {}", (Object)player);
                playerLightSourceContainer = new PlayerLightSourceContainer(this, player);
                this.playerLightsMap.put(player, playerLightSourceContainer);
            }
            int prevLight = playerLightSourceContainer.lightLevel;
            boolean isUnderwater = this.checkPlayerWater(player);
            ItemStack item = ItemStack.EMPTY;
            LOGGER.trace("checking for light from main hand item {}", (Object)player.getItemInHand(InteractionHand.MAIN_HAND));
            int main = this.getLightFromItemStack(player.getItemInHand(InteractionHand.MAIN_HAND), isUnderwater, player.registryAccess());
            int off = this.getLightFromItemStack(player.getItemInHand(InteractionHand.OFF_HAND), isUnderwater, player.registryAccess());
            if (main >= off && main > 0) {
                item = player.getItemInHand(InteractionHand.MAIN_HAND);
                playerLightSourceContainer.lightLevel = main;
            } else if (off >= main && off > 0) {
                item = player.getItemInHand(InteractionHand.OFF_HAND);
                playerLightSourceContainer.lightLevel = off;
            } else {
                playerLightSourceContainer.lightLevel = 0;
            }
            LOGGER.trace("Self light tick, main:{}, off:{}, light:{}, chosen itemstack:{}", (Object)main, (Object)off, (Object)playerLightSourceContainer.lightLevel, (Object)item);
            for (ItemStack armor : player.getInventory().armor) {
                playerLightSourceContainer.lightLevel = Math.max(playerLightSourceContainer.lightLevel, this.getLightFromItemStack(armor, isUnderwater, player.registryAccess()));
            }
            if (prevLight != 0 && playerLightSourceContainer.lightLevel != prevLight) {
                playerLightSourceContainer.lightLevel = 0;
            } else if (player.isOnFire()) {
                playerLightSourceContainer.lightLevel = 15;
            }
            if (!playerLightSourceContainer.enabled && playerLightSourceContainer.lightLevel > 0) {
                this.enableLight(playerLightSourceContainer);
            } else if (playerLightSourceContainer.enabled && playerLightSourceContainer.lightLevel < 1) {
                this.disableLight(playerLightSourceContainer);
            }
        } else {
            PlayerLightSourceContainer playerLightSourceContainer = this.playerLightsMap.get(player);
            if (playerLightSourceContainer != null) {
                this.disableLight(playerLightSourceContainer);
                this.playerLightsMap.remove(playerLightSourceContainer.thePlayer);
            }
        }
    }

    private boolean checkPlayerWater(Player thePlayer) {
        return thePlayer.isEyeInFluid(FluidTags.WATER);
    }

    private int getLightFromItemStack(ItemStack stack, boolean isUnderwater, RegistryAccess registryAccess) {
        if (isUnderwater && (notWaterProofItems.getLightLevel(stack, registryAccess) > 0 || stack.getTags().anyMatch(rl -> rl.location().equals((Object)DynamicLights.NOT_WATERPROOF_TAG)))) {
            return 0;
        }
        int level = ItemLightLevels.getLightFromItemStack(stack, "self");
        if (level > 0 && level <= 15) {
            return level;
        }
        return itemsMap.getLightLevel(stack, registryAccess);
    }

    private void enableLight(PlayerLightSourceContainer container) {
        DynamicLights.addLightSource(container);
        container.enabled = true;
    }

    private void disableLight(PlayerLightSourceContainer container) {
        DynamicLights.removeLightSource(container);
        container.enabled = false;
    }

    class PlayerLightSourceContainer
    implements IDynamicLightSource {
        int lightLevel;
        boolean enabled;
        Player thePlayer;

        PlayerLightSourceContainer(PlayerSelfLightSource this$0, Player player) {
            this.thePlayer = player;
            this.lightLevel = 0;
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.thePlayer;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }
}

