/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.modules;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.ItemLightLevels;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DroppedItemsLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private static final HashMap<ItemEntity, EntityItemAdapter> trackedItemMap;
    private LightConfig config;

    public DroppedItemsLightSource() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverStartEvent(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        LightConfig defaultConfig = new LightConfig();
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.TORCH), 14, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.LANTERN), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.CAMPFIRE), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.GLOWSTONE), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), 10, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.REDSTONE_ORE), 10, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.REDSTONE_BLOCK), 10, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_LANTERN), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE), 15, (RegistryAccess)registryAccess));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_TORCH), 14, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.TORCH), 0, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_TORCH), 0, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.CAMPFIRE), 0, (RegistryAccess)registryAccess));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.SOUL_CAMPFIRE), 0, (RegistryAccess)registryAccess));
        File configFile = server.getServerDirectory().resolve("config" + File.separatorChar + "dynamiclights_droppeditems.cfg").toFile();
        try {
            this.config = GsonConfig.loadConfigWithDefault(LightConfig.class, configFile, defaultConfig);
            if (this.config == null) {
                throw new UnsupportedOperationException("DroppedItemsLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(this.config.getItemsList(), LOGGER, (RegistryAccess)registryAccess);
            notWaterProofItems = new ItemConfigHelper(this.config.getNotWaterProofList(), LOGGER, (RegistryAccess)registryAccess);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void entityJoinsWorld(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        int lightLevel;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (lightLevel = this.getLightFromItemStack((itemEntity = (ItemEntity)entity).getItem(), event.getLevel().registryAccess())) > 0) {
            EntityItemAdapter entityItemAdapter = new EntityItemAdapter(itemEntity);
            trackedItemMap.put(itemEntity, entityItemAdapter);
        }
    }

    @SubscribeEvent
    public void serverWorldTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Iterator<Map.Entry<ItemEntity, EntityItemAdapter>> iterator = trackedItemMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ItemEntity, EntityItemAdapter> mapEntry = iterator.next();
            if (mapEntry.getKey().isAlive()) {
                mapEntry.getValue().onTick();
                continue;
            }
            iterator.remove();
        }
    }

    private int getLightFromItemStack(ItemStack stack, RegistryAccess registryAccess) {
        int level = ItemLightLevels.getLightFromItemStack(stack, "dropped");
        if (level > 0 && level <= 15) {
            return level;
        }
        return itemsMap.getLightLevel(stack, registryAccess);
    }

    static {
        trackedItemMap = new HashMap();
    }

    private class EntityItemAdapter
    implements IDynamicLightSource {
        private ItemEntity entity;
        private int lightLevel = 0;
        private boolean enabled = false;
        private boolean notWaterProof;

        public EntityItemAdapter(ItemEntity eI) {
            this.entity = eI;
            this.notWaterProof = notWaterProofItems.getLightLevel(eI.getItem(), eI.registryAccess()) > 0 || eI.getItem().getTags().anyMatch(rl -> rl.location().equals((Object)DynamicLights.NOT_WATERPROOF_TAG));
        }

        public void onTick() {
            if (this.entity.isOnFire()) {
                this.lightLevel = 15;
            } else {
                this.lightLevel = DroppedItemsLightSource.this.getLightFromItemStack(this.entity.getItem(), this.entity.registryAccess());
                if (this.notWaterProof && this.entity.isInWater()) {
                    this.lightLevel = 0;
                }
            }
            if (!this.enabled && this.lightLevel > 0) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 1) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.notWaterProof && this.entity.isInWater() ? 0 : this.lightLevel;
        }
    }
}

