/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private Map<ItemStack, Integer> itemStackList = new HashMap<ItemStack, Integer>();

    public ItemConfigHelper(List<? extends String> items, Logger logger, RegistryAccess registryAccess) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.parseTag((String)string);
                ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)nbt);
                if (!itemStack.isEmpty()) {
                    int lightLevel = 15;
                    if (nbt.contains("lightLevel")) {
                        lightLevel = nbt.getShort("lightLevel");
                        nbt.remove("lightLevel");
                    }
                    this.itemStackList.put(itemStack, lightLevel);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not create itemStack from {}", (Object)string);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack, int lightLevel, RegistryAccess registryAccess) {
        CompoundTag resultTag = (CompoundTag)itemStack.save((HolderLookup.Provider)registryAccess);
        if (lightLevel > 0) {
            resultTag.putShort("lightLevel", (short)lightLevel);
        }
        resultTag.remove("count");
        resultTag.putBoolean("anyNbtMatch", true);
        return resultTag.toString();
    }

    public int getLightLevel(ItemStack stack, RegistryAccess registryAccess) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.itemStackList.entrySet()) {
            ItemStack is = entry.getKey();
            if (is.getItem() != stack.getItem() || !this.tagsMatchWithWildcard(is, stack, registryAccess)) continue;
            return entry.getValue();
        }
        return 0;
    }

    private boolean tagsMatchWithWildcard(ItemStack configuredStack, ItemStack ingameStack, RegistryAccess registryAccess) {
        CompoundTag resultTag = (CompoundTag)configuredStack.save((HolderLookup.Provider)registryAccess);
        if (resultTag.contains("anyNbtMatch")) {
            return true;
        }
        return ItemStack.isSameItem((ItemStack)configuredStack, (ItemStack)ingameStack);
    }
}

