/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.recipecache;

import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.config.CommonConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;

public class CachedRecipeList {
    public final List<RecipeHolder> recipes;
    public final List<ItemStack> originStacks;
    public final RecipeType originType;
    public int useCount = 0;
    public boolean reported = false;

    public CachedRecipeList(List<RecipeHolder> recipes, List<ItemStack> originStacks, RecipeType originType) {
        this.recipes = recipes;
        this.originStacks = originStacks;
        this.originType = originType;
    }

    public CachedRecipeList(RecipeType recipeTypeIn, RecipeInput inventoryIn) {
        this.originType = recipeTypeIn;
        this.recipes = new ArrayList<RecipeHolder>();
        this.originStacks = new ArrayList<ItemStack>();
        if (inventoryIn != null) {
            for (int i = 0; i < inventoryIn.size(); ++i) {
                ItemStack stack = inventoryIn.getItem(i);
                if (stack == null || stack.isEmpty()) continue;
                this.originStacks.add(stack.copy());
            }
        }
    }

    public <T extends Recipe<C>, C extends RecipeInput> void report(RecipeType recipeTypeIn, RecipeInput inventoryIn, List<RecipeHolder<T>> recipes) {
        if (!this.reported && ((CommonConfiguration)RecipeEssentials.config.getCommonConfig()).logCachingErrors) {
            this.reported = true;
            CachedRecipeList temp = new CachedRecipeList(recipeTypeIn, inventoryIn);
            RecipeEssentials.LOGGER.warn("Unable to optimize some recipes, printing mismatch");
            RecipeEssentials.LOGGER.warn("Mismatching cached recipe lists for input: type:" + String.valueOf(recipeTypeIn) + " stacks:" + String.valueOf(temp.originStacks));
            RecipeEssentials.LOGGER.warn("Result recipe list:" + String.valueOf(recipes.stream().map(RecipeHolder::id).toList()));
            RecipeEssentials.LOGGER.warn("Cached values: type:" + String.valueOf(this.originType) + " stacks:" + String.valueOf(this.originStacks));
            RecipeEssentials.LOGGER.warn("Cached recipe list:" + String.valueOf(this.recipes.stream().map(RecipeHolder::id).toList()));
        }
        this.useCount = 0;
    }
}

