/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.integration.neoforge;

import java.lang.reflect.Method;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AlexCavesCompatImpl {
    public static HolderReference<SoftFluid> ACID_SF = HolderReference.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"acid"), (ResourceKey)SoftFluidRegistry.KEY);
    public static HolderReference<FluidType> ACID_FLUID_TYPE = HolderReference.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"acid"), (ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES);
    public static HolderReference<Block> ACID_BLOCK = HolderReference.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"acid"), (ResourceKey)Registries.BLOCK);
    public static HolderReference<ParticleType<?>> ACID_BUBBLE = HolderReference.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"acid_bubble"), (ResourceKey)Registries.PARTICLE_TYPE);
    public static HolderReference<SoundEvent> ACID_IDLE = HolderReference.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"acid_idle"), (ResourceKey)Registries.SOUND_EVENT);
    public static final Method SET_H = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"setFluidTypeHeight", (Class[])new Class[]{FluidType.class, Double.TYPE});

    public static void acidDamage(SoftFluidStack fluid, Level level, BlockPos pos, BlockState state, Entity entity) {
        if (fluid.is(ACID_SF)) {
            try {
                FluidType acidFluid = (FluidType)ACID_FLUID_TYPE.get(level);
                double oldH = entity.getFluidTypeHeight(acidFluid);
                double stateH = (double)((Integer)state.getValue((Property)LiquidCauldronBlock.LEVEL)).intValue() * 0.25;
                SET_H.invoke((Object)entity, acidFluid, stateH);
                Block acid = (Block)ACID_BLOCK.get(level);
                acid.defaultBlockState().entityInside(level, pos, entity);
                SET_H.invoke((Object)entity, acidFluid, oldH);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void acidParticles(SoftFluidStack fluid, Level level, BlockPos pos, RandomSource rand, double height) {
        if (fluid.is(ACID_SF)) {
            if (rand.nextInt(400) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)ACID_IDLE.get(level), SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
            }
            LiquidCauldronBlock.addSurfaceParticles((ParticleOptions)ACID_BUBBLE.get(level), level, pos, 1, height, rand, (rand.nextFloat() - 0.5f) * 0.1f, 0.05f + rand.nextFloat() * 0.1f, (rand.nextFloat() - 0.5f) * 0.1f);
        }
    }

    static {
        SET_H.setAccessible(true);
    }
}

