/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.network.ClientBoundPlaySplashParticlesMessage;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public ModCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, new CauldronInteraction.InteractionMap("amendments_empty", Map.of()));
    }

    public Item asItem() {
        return Items.CAULDRON;
    }

    public abstract IntegerProperty getLevelProperty();

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)this.getLevelProperty());
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (this.isEntityInsideContent(state, pos, entity)) {
            if (!level.isClientSide) {
                ModCauldronBlock.playSplashEffects(entity, this.getContentHeight(state));
            }
            super.fallOn(level, state, pos, entity, 0.0f);
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public static void playExtinguishSound(Level level, BlockPos pos, Entity entity) {
        level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, entity.getSoundSource(), 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.isEntityInsideContent(state, pos, entity)) {
            entity.wasTouchingWater = true;
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                BlockEntity blockEntity;
                entity.clearFire();
                ModCauldronBlock.playExtinguishSound(level, pos, entity);
                if (entity.mayInteract(level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                    te.consumeOneLayer();
                    level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                }
            }
            this.handleEntityInside(state, level, pos, entity);
        }
    }

    protected abstract void handleEntityInside(BlockState var1, Level var2, BlockPos var3, Entity var4);

    public boolean doCraftItem(Level level, BlockPos pos, Player player, InteractionHand hand, SoftFluidStack fluid, ItemStack itemStack, ItemStack crafted, float layerPerItem, int itemCountMultiplier) {
        int maxRecolorable = (int)((float)(crafted.getCount() * itemCountMultiplier * fluid.getCount()) / layerPerItem);
        int amountToRecolor = Math.min(maxRecolorable, itemStack.getCount());
        if (amountToRecolor <= 0) {
            return false;
        }
        crafted.setCount(amountToRecolor);
        level.playSound(player, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.3f);
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, itemStack);
        itemStack.consume(amountToRecolor, (LivingEntity)player);
        fluid.consume(Mth.ceil((float)(layerPerItem * (float)amountToRecolor / (float)itemCountMultiplier)), (LivingEntity)player);
        if (itemStack.isEmpty()) {
            player.setItemInHand(hand, crafted);
        } else if (!player.getInventory().add(crafted)) {
            player.drop(crafted, false);
        }
        return true;
    }

    public abstract BlockState updateStateOnFluidChange(BlockState var1, Level var2, BlockPos var3, SoftFluidStack var4);

    public static void addSurfaceParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.getX() + 0.1875 + (double)rand.nextFloat() * 0.625;
            double y = (double)pos.getY() + surface;
            double z = (double)pos.getZ() + 0.1875 + (double)rand.nextFloat() * 0.625;
            level.addParticle(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public static void playSplashEffects(Entity entity, double waterHeight) {
        entity.gameEvent((Holder)GameEvent.SPLASH);
        Level level = entity.level();
        Entity feetEntity = entity.isVehicle() && entity.getControllingPassenger() != null ? entity.getControllingPassenger() : entity;
        float offset = feetEntity == entity ? 0.2f : 0.9f;
        Vec3 movement = feetEntity.getDeltaMovement();
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.x * movement.x * 0.2 + movement.y * movement.y + movement.z * movement.z * 0.2) * offset);
        BlockPos pos = BlockPos.containing((Position)entity.position());
        Vec3 hitPos = new Vec3(entity.getX(), (double)pos.getY() + waterHeight, entity.getZ());
        RandomSource rand = level.random;
        if (speed < 0.25f) {
            level.playSound(null, hitPos.x(), hitPos.y(), hitPos.z(), entity.getSwimSplashSound(), entity.getSoundSource(), speed, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
        } else {
            level.playSound(null, hitPos.x(), hitPos.y(), hitPos.z(), entity.getSwimHighSpeedSplashSound(), entity.getSoundSource(), speed, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
        }
        ClientBoundPlaySplashParticlesMessage particlePacket = new ClientBoundPlaySplashParticlesMessage(hitPos, speed, feetEntity.getBbWidth());
        NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)entity, (Message)particlePacket);
    }
}

