/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.recipe.RecipeUtils;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.AlexCavesCompat;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlock
extends ModCauldronBlock {
    public static final MapCodec<LiquidCauldronBlock> CODEC = LiquidCauldronBlock.simpleCodec(LiquidCauldronBlock::new);
    public static final int MAX_LEVEL = PlatHelper.getPlatform().isFabric() ? 3 : 4;
    public static final IntegerProperty LEVEL = PlatHelper.getPlatform().isFabric() ? BlockStateProperties.LEVEL_CAULDRON : ModBlockProperties.LEVEL_1_4;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;
    public static final BooleanProperty BOILING = ModBlockProperties.BOILING;

    public LiquidCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(value -> (Integer)value.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends LiquidCauldronBlock> codec() {
        return CODEC;
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL, LIGHT_LEVEL, BOILING});
    }

    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return fluid != Fluids.WATER && fluid != Fluids.LAVA;
    }

    public void receiveStalactiteDrip(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        BlockEntity blockEntity;
        if (!this.isFull(state) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidStack sf = SoftFluidStack.fromFluid((Fluid)fluid, (int)1, null);
            if (!sf.isEmpty() && te.getSoftFluidTank().addFluid(sf, false) != 0) {
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
                level.levelEvent(1047, pos, 0);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            if (te.interactWithPlayerItem(player, hand, stack)) {
                this.maybeSendPotionMixMessage(te.getSoftFluidTank(), player);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!CommonConfigs.CAULDRON_CRAFTING.get().booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            SoftFluidStack fluid = tank.getFluid();
            Pair<ItemStack, Float> crafted = RecipeUtils.craftWithFluid(level, tank.getFluid(), stack, true);
            if (crafted != null) {
                int mult;
                int n = mult = fluid.is((Holder)BuiltInSoftFluids.POTION) ? CommonConfigs.POTION_RECIPES_PER_LAYER.get() : 1;
                if (this.doCraftItem(level, pos, player, hand, fluid, stack, (ItemStack)crafted.getFirst(), ((Float)crafted.getSecond()).floatValue(), mult)) {
                    te.setChanged();
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL) == MAX_LEVEL;
    }

    protected double getContentHeight(BlockState state) {
        return 0.4375 + 0.125 * (double)((Integer)state.getValue((Property)LEVEL)).intValue();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        BlockState s = super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        if (direction == Direction.DOWN && (blockEntity = level.getBlockEntity(currentPos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            boolean isFire = LiquidCauldronBlock.shouldBoil(neighborState, te.getSoftFluidTank().getFluid(), level, neighborPos);
            s = (BlockState)s.setValue((Property)BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return s;
    }

    public static boolean shouldBoil(BlockState belowState, SoftFluidStack fluid, LevelAccessor level, BlockPos pos) {
        if (!belowState.is(ModTags.HEAT_SOURCES) || !fluid.is(ModTags.CAN_BOIL)) {
            return false;
        }
        if (belowState.hasProperty((Property)CampfireBlock.LIT)) {
            return (Boolean)belowState.getValue((Property)CampfireBlock.LIT);
        }
        Block block = belowState.getBlock();
        if (block instanceof ILightable) {
            ILightable il = (ILightable)block;
            return il.isLitUp(belowState, (BlockGetter)level, pos);
        }
        return true;
    }

    @Override
    protected void handleEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)BOILING)).booleanValue() && entity instanceof LivingEntity) {
            entity.hurt(new DamageSource(ModRegistry.BOILING_DAMAGE), 1.0f);
        }
        if (entity.mayInteract(level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            ItemEntity ie;
            LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
            PotionBottleType potType = this.getPotType(fluid);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (potType != null && potType != PotionBottleType.REGULAR && this.applyPotionFluidEffects(level, pos, living, fluid)) {
                    tile.consumeOneLayer();
                    level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidDamage(fluid, level, pos, state, entity);
                }
            }
            if (!tile.isGlowing() && potType != null && entity instanceof ItemEntity && (ie = (ItemEntity)entity).getItem().is(Items.GLOW_INK_SAC) && this.isEntityInsideContent(state, pos, entity)) {
                ModCauldronBlock.playSplashEffects(entity, this.getContentHeight(state));
                tile.setGlowing(true);
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                ie.getItem().shrink(1);
                if (ie.getItem().isEmpty()) {
                    ie.discard();
                }
            }
        }
    }

    private boolean applyPotionFluidEffects(Level level, BlockPos pos, LivingEntity living, SoftFluidStack stack) {
        List<MobEffectInstance> effects = this.getPotionEffects(stack);
        boolean success = false;
        for (MobEffectInstance effect : effects) {
            Holder ef = effect.getEffect();
            if (living.hasEffect(ef)) continue;
            if (((MobEffect)ef.value()).isInstantenous()) {
                ((MobEffect)ef.value()).applyInstantenousEffect(null, null, living, effect.getAmplifier(), 1.0);
            } else {
                living.addEffect(new MobEffectInstance(effect));
            }
            success = true;
        }
        if (success) {
            level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return success;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidTank tank = te.getSoftFluidTank();
            if (((Boolean)state.getValue((Property)BOILING)).booleanValue()) {
                int color = tank.getCachedParticleColor((BlockAndTintGetter)level, pos);
                int light = tank.getFluidValue().getEmissivity();
                LiquidCauldronBlock.playBubblingAnimation(level, pos, this.getContentHeight(state), rand, color, light);
            }
            if (level.random.nextInt(4) == 0) {
                SoftFluidStack fluid = tank.getFluid();
                PotionBottleType type = this.getPotType(fluid);
                double height = this.getContentHeight(state);
                if (type != null) {
                    if (this.getPotionEffects(fluid).size() >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
                        LiquidCauldronBlock.addSurfaceParticles((ParticleOptions)ParticleTypes.SMOKE, level, pos, 2, height, rand, 0.0f, 0.0f, 0.0f);
                    }
                    if (type != PotionBottleType.REGULAR) {
                        int color = tank.getCachedParticleColor((BlockAndTintGetter)level, pos);
                        int alpha = type == PotionBottleType.SPLASH ? Mth.floor((float)38.25f) : 255;
                        ColorParticleOption particle = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)alpha, (int)color));
                        this.addPotionParticles((ParticleOptions)particle, level, pos, 1, height, rand, color);
                    }
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidParticles(fluid, level, pos, rand, height);
                }
                BlockPos blockPos = pos.above();
                if (fluid.is((Holder)BuiltInSoftFluids.LAVA) && level.getBlockState(blockPos).isAir() && !level.getBlockState(blockPos).isSolidRender((BlockGetter)level, blockPos)) {
                    Vec3 c = pos.getCenter();
                    if (rand.nextInt(20) == 0) {
                        LiquidCauldronBlock.addSurfaceParticles((ParticleOptions)ParticleTypes.LAVA, level, pos, 1, height, rand, 0.0f, 0.0f, 0.0f);
                        level.playLocalSound(c.x, height, c.z, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                    }
                    if (rand.nextInt(40) == 0) {
                        level.playLocalSound(c.x, height, c.z, SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                    }
                }
            }
        }
    }

    @Nullable
    private PotionBottleType getPotType(SoftFluidStack stack) {
        if (stack.is((Holder)BuiltInSoftFluids.POTION)) {
            return (PotionBottleType)stack.getOrDefault((DataComponentType)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR);
        }
        return null;
    }

    private List<MobEffectInstance> getPotionEffects(SoftFluidStack stack) {
        return StreamSupport.stream(((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects().spliterator(), false).toList();
    }

    public static void playBubblingAnimation(Level level, BlockPos pos, double surface, RandomSource rand, int color, int light) {
        SimpleParticleType type = (SimpleParticleType)ModRegistry.BOILING_PARTICLE.get();
        int count = 2;
        LiquidCauldronBlock.addSurfaceParticles((ParticleOptions)type, level, pos, count, surface, rand, color, (float)pos.getY() + 0.3125f, light);
        if (level.random.nextInt(4) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.4f + level.random.nextFloat() * 0.2f, 0.35f + level.random.nextFloat() * 0.2f, false);
        }
    }

    private void addPotionParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        LiquidCauldronBlock.addSurfaceParticles(type, level, pos, count, surface, rand, r, g, b);
    }

    @Override
    public BlockState updateStateOnFluidChange(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        BlockState exploded = this.maybeExplode(state, level, pos, fluid);
        if (exploded != null) {
            return exploded;
        }
        int light = fluid.fluid().getLuminosity();
        if (light != (Integer)state.getValue((Property)ModBlockProperties.LIGHT_LEVEL)) {
            state = (BlockState)state.setValue((Property)ModBlockProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(light));
        }
        int height = fluid.getCount();
        state = fluid.isEmpty() ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(height));
        return state;
    }

    public void maybeSendPotionMixMessage(SoftFluidTank fluidTank, Player player) {
        List<MobEffectInstance> potionEffects;
        int potionEffectAmount;
        if (fluidTank.getFluid().is((Holder)BuiltInSoftFluids.POTION) && (potionEffectAmount = (potionEffects = this.getPotionEffects(fluidTank.getFluid())).size()) == CommonConfigs.POTION_MIXING_LIMIT.get()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.amendments.cauldron"), true);
        }
    }

    @Nullable
    private BlockState maybeExplode(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        List<MobEffectInstance> potionEffects = this.getPotionEffects(fluid);
        int potionEffectAmount = potionEffects.size();
        if (potionEffectAmount >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
            if (potionEffectAmount > CommonConfigs.POTION_MIXING_LIMIT.get()) {
                level.destroyBlock(pos, true);
                Vec3 vec3 = pos.getCenter();
                level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, vec3.x, vec3.y, vec3.z, 1.4f, false, Level.ExplosionInteraction.NONE);
                return state;
            }
            if (level.isClientSide) {
                LiquidCauldronBlock.addSurfaceParticles((ParticleOptions)ParticleTypes.SMOKE, level, pos, 12, this.getContentHeight(state), level.random, 0.0f, 0.0f, 0.0f);
            }
            level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return null;
        }
        Map<MobEffect, MobEffect> inverse = CommonConfigs.INVERSE_POTIONS.get();
        List<MobEffect> effects = potionEffects.stream().map(e -> (MobEffect)e.getEffect().value()).toList();
        for (MobEffect effect : effects) {
            MobEffect inv = inverse.get(effect);
            if (inv == null || !effects.contains(inv)) continue;
            if (level.isClientSide) {
                LiquidCauldronBlock.addSurfaceParticles((ParticleOptions)ParticleTypes.POOF, level, pos, 8, this.getContentHeight(state), level.random, 0.0f, 0.01f + level.random.nextFloat() * 0.1f, 0.0f);
            }
            level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return Blocks.CAULDRON.defaultBlockState();
        }
        return null;
    }
}

