/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.compostbag.tooltip;

import dev.dhyces.compostbag.CompostBag;
import dev.dhyces.compostbag.tooltip.CompostBagTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Matrix4f;

public record ClientCompostBagTooltip(int maxCount, int count, int maxLevel, int level) implements ClientTooltipComponent
{
    public static final ResourceLocation TEXTURE_LOCATION = CompostBag.id("textures/gui/compost_bag_tooltip.png");
    private static final ItemStack BONEMEAL = Items.BONE_MEAL.getDefaultInstance();

    public ClientCompostBagTooltip(CompostBagTooltip tooltip) {
        this(tooltip.maxCount(), tooltip.count(), tooltip.maxLevel(), tooltip.level());
    }

    public int getHeight() {
        return 24;
    }

    public int getWidth(Font font) {
        MutableComponent title = Component.translatable((String)"item.compostbag.compost_bag");
        int titleWidth = font.width((FormattedText)title);
        int countTextWidth = font.width(this.countText());
        int binWidth = 20;
        return Math.max(countTextWidth + binWidth, titleWidth);
    }

    public void renderText(Font pFont, int pX, int pY, Matrix4f pMatrix4f, MultiBufferSource.BufferSource pBufferSource) {
        String text = this.countText();
        pFont.drawInBatch(text, (float)(pX + this.getWidth(pFont) - pFont.width(text)), (float)(pY + 13), this.count == 0 ? 0x999999 : 0xFFFFFF, false, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 255, false);
    }

    private String countText() {
        return this.count + "/" + this.maxCount;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.maxLevel > 0) {
            this.blitBin(guiGraphics, x, y);
            this.blitFill(guiGraphics, x, y);
        }
        int center = this.getWidth(font) - 10 - font.width(this.countText()) / 2;
        guiGraphics.renderItem(BONEMEAL, x + center, y - 3);
    }

    private void blitFill(GuiGraphics guiGraphics, int x, int y) {
        int renderLevel = (int)Math.ceil((double)this.level / (double)this.maxLevel * 16.0);
        guiGraphics.blit(TEXTURE_LOCATION, x, y + 16 - renderLevel, 0.0f, (float)(32 - renderLevel), 16, renderLevel, 32, 32);
    }

    private void blitBin(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(TEXTURE_LOCATION, x, y, 0.0f, 0.0f, 16, 16, 32, 32);
    }
}

