/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.compostbag.item;

import dev.dhyces.compostbag.CompostBag;
import dev.dhyces.compostbag.platform.Services;
import dev.dhyces.compostbag.tooltip.CompostBagTooltip;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CompostBagItem
extends Item {
    public static final DispenseItemBehavior DISPENSE_BEHAVIOR = new OptionalDispenseItemBehavior(){

        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            this.setSuccess(true);
            ServerLevel level = blockSource.level();
            BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
            ItemStack bonemeal = CompostBagItem.getTagItem(stack);
            if (bonemeal.isEmpty() || !BoneMealItem.growCrop((ItemStack)bonemeal, (Level)level, (BlockPos)blockPos) && !BoneMealItem.growWaterPlant((ItemStack)bonemeal, (Level)level, (BlockPos)blockPos, null)) {
                this.setSuccess(false);
            } else if (!level.isClientSide) {
                level.levelEvent(1505, blockPos, 0);
                CompostBagItem.setBonemeal(stack, bonemeal.getCount());
            }
            return stack;
        }
    };

    public CompostBagItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack bonemeal = CompostBagItem.getTagItem(context.getItemInHand());
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        if (!bonemeal.isEmpty() && Services.PLATFORM.bonemeal(bonemeal, level, blockpos, context.getPlayer())) {
            CompostBagItem.setBonemeal(context.getItemInHand(), bonemeal.getCount());
            this.playBonemealSound(level, blockpos);
            level.levelEvent(1505, blockpos, 15);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean isBarVisible(ItemStack stack) {
        return CompostBagItem.getBonemeal(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return 1 + (int)((float)CompostBagItem.getBonemeal(stack) / (float)CompostBagItem.getMaxBonemeal(stack) * 13.0f - 1.0f);
    }

    public int getBarColor(ItemStack stack) {
        return CompostBagItem.getBonemeal(stack) < CompostBagItem.getMaxBonemeal(stack) ? 0x6666FF : 0xFF3737;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        if (!slot.allowModification(player)) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY) {
            if (!player.level().isClientSide || player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
                if (slot.hasItem()) {
                    ItemStack slotItem = slot.getItem();
                    if (this.isCompostable(slotItem)) {
                        this.compostAll(stack, slotItem, player);
                    }
                    if (slotItem.is(Items.BONE_MEAL) && CompostBagItem.getBonemeal(stack) < CompostBagItem.getMaxBonemeal(stack)) {
                        this.insertBonemeal(stack, slotItem);
                        this.playInsertSound(player);
                    }
                } else {
                    this.remove(stack, Items.BONE_MEAL.getDefaultMaxStackSize()).ifPresent(c -> {
                        this.playRemoveSound(player);
                        slot.set(c);
                    });
                }
            }
            return true;
        }
        return super.overrideStackedOnOther(stack, slot, clickAction, player);
    }

    private void compostAll(ItemStack bag, ItemStack slotItem, Player player) {
        int shrinkBy = 0;
        while (shrinkBy != slotItem.getCount() && !this.isBagFull(bag)) {
            InteractionResultHolder<ItemStack> result = this.simulateCompost(bag, slotItem, player);
            if (!result.getResult().consumesAction()) continue;
            if (!((ItemStack)result.getObject()).isEmpty()) {
                CompostBagItem.setLevel(bag, 0);
                CompostBagItem.growBonemealCount(bag, 1);
            } else if (result.getResult().equals((Object)InteractionResult.SUCCESS)) {
                CompostBagItem.growLevel(bag, 1);
            }
            ++shrinkBy;
        }
        if (shrinkBy > 0) {
            this.playReadySound(player);
        }
        this.playFillSound(player);
        slotItem.shrink(shrinkBy);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!slot.allowModification(player)) {
            return false;
        }
        if (clickAction == ClickAction.SECONDARY) {
            if (!player.level().isClientSide || player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
                if (!otherItem.isEmpty()) {
                    InteractionResultHolder<ItemStack> result;
                    int count = CompostBagItem.getBonemeal(stack);
                    if (this.isCompostable(otherItem) && !this.isBagFull(stack) && (result = this.simulateCompost(stack, otherItem, player)).getResult().consumesAction()) {
                        if (!((ItemStack)result.getObject()).isEmpty()) {
                            CompostBagItem.setLevel(stack, 0);
                            CompostBagItem.growBonemealCount(stack, 1);
                            this.playReadySound(player);
                        } else if (result.getResult().equals((Object)InteractionResult.SUCCESS)) {
                            CompostBagItem.growLevel(stack, 1);
                            this.playFillSuccessSound(player);
                        }
                        this.playFillSound(player);
                        otherItem.shrink(1);
                    }
                    if (otherItem.is(Items.BONE_MEAL) && count < CompostBagItem.getMaxBonemeal(stack)) {
                        this.insertBonemeal(stack, otherItem);
                        this.playInsertSound(player);
                    }
                } else {
                    this.remove(stack, Items.BONE_MEAL.getDefaultMaxStackSize()).ifPresent(c -> {
                        this.playRemoveSound(player);
                        slotAccess.set(c);
                    });
                }
            }
            return true;
        }
        return super.overrideOtherStackedOnMe(stack, otherItem, slot, clickAction, player, slotAccess);
    }

    private InteractionResultHolder<ItemStack> simulateCompost(ItemStack stack, ItemStack item, Player player) {
        float compostable = this.getCompostable(item);
        if (compostable == 0.0f) {
            return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
        }
        int lvl = CompostBagItem.getLevel(stack);
        if (!(lvl == 0 && compostable < 0.0f || player.level().getRandom().nextDouble() < (double)compostable)) {
            return InteractionResultHolder.consume((Object)ItemStack.EMPTY);
        }
        if (lvl < CompostBagItem.getMaxLevel(stack)) {
            return InteractionResultHolder.success((Object)ItemStack.EMPTY);
        }
        return InteractionResultHolder.success((Object)new ItemStack((ItemLike)Items.BONE_MEAL));
    }

    private boolean isCompostable(ItemStack stack) {
        return Services.PLATFORM.getCompostChance(stack) > 0.0f;
    }

    private float getCompostable(ItemStack stack) {
        return Services.PLATFORM.getCompostChance(stack);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new CompostBagTooltip(CompostBagItem.getMaxBonemeal(stack), CompostBagItem.getBonemeal(stack), CompostBagItem.getMaxLevel(stack), CompostBagItem.getLevel(stack)));
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        if (CompostBagItem.getLevel(stack) > CompostBagItem.getMaxLevel(stack)) {
            CompostBagItem.setLevel(stack, CompostBagItem.getMaxLevel(stack));
        }
        if (CompostBagItem.getBonemeal(stack) > CompostBagItem.getMaxBonemeal(stack)) {
            CompostBagItem.setBonemeal(stack, CompostBagItem.getMaxBonemeal(stack));
        }
    }

    private ItemStack insertBonemeal(ItemStack stack, ItemStack bonemeal) {
        if (bonemeal.isEmpty() || !(bonemeal.getItem() instanceof BoneMealItem)) {
            return bonemeal;
        }
        int max = Math.min(bonemeal.getCount(), CompostBagItem.getMaxBonemeal(stack) - CompostBagItem.getBonemeal(stack));
        CompostBagItem.growBonemealCount(stack, max);
        bonemeal.shrink(max);
        return bonemeal;
    }

    private boolean isBagFull(ItemStack stack) {
        return CompostBagItem.getBonemeal(stack) >= CompostBagItem.getMaxBonemeal(stack) && CompostBagItem.getLevel(stack) >= CompostBagItem.getMaxLevel(stack);
    }

    private Optional<ItemStack> remove(ItemStack bag, int amount) {
        int count = Math.min(CompostBagItem.getBonemeal(bag), amount);
        if (count == 0) {
            return Optional.empty();
        }
        ItemStack item = new ItemStack((ItemLike)Items.BONE_MEAL, count);
        CompostBagItem.growBonemealCount(bag, -count);
        return Optional.of(item);
    }

    private static ItemStack getTagItem(ItemStack bag) {
        int count = CompostBagItem.getBonemeal(bag);
        if (count == 0) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)Items.BONE_MEAL, count);
    }

    public static int getMaxBonemeal(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)CompostBag.MAX_BONEMEAL_COUNT.value(), (Object)0);
    }

    public static void growBonemealCount(ItemStack bag, int amount) {
        CompostBagItem.setBonemeal(bag, CompostBagItem.getBonemeal(bag) + amount);
    }

    private static void setBonemeal(ItemStack bag, int count) {
        if (count == 0) {
            bag.remove((DataComponentType)CompostBag.BONEMEAL_COUNT.value());
            return;
        }
        bag.set((DataComponentType)CompostBag.BONEMEAL_COUNT.value(), (Object)count);
    }

    public static int getBonemeal(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)CompostBag.BONEMEAL_COUNT.value(), (Object)0);
    }

    public static int getMaxLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)CompostBag.MAX_COMPOST_LEVEL.value(), (Object)0);
    }

    public static void growLevel(ItemStack stack, int amount) {
        CompostBagItem.setLevel(stack, CompostBagItem.getLevel(stack) + amount);
    }

    public static void setLevel(ItemStack stack, int lvl) {
        if (lvl == 0) {
            stack.remove((DataComponentType)CompostBag.COMPOST_LEVEL.value());
            return;
        }
        stack.set((DataComponentType)CompostBag.COMPOST_LEVEL.value(), (Object)lvl);
    }

    public static int getLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)CompostBag.COMPOST_LEVEL.value(), (Object)0);
    }

    private void playBonemealSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.PLAYERS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
    }

    private void playFillSound(Player player) {
        this.playerSound(player, SoundEvents.COMPOSTER_FILL, 0.8f);
    }

    private void playFillSuccessSound(Player player) {
        this.playerSound(player, SoundEvents.COMPOSTER_FILL_SUCCESS, 0.8f);
    }

    private void playReadySound(Player player) {
        this.playerSound(player, SoundEvents.COMPOSTER_READY, 0.8f);
    }

    private void playRemoveSound(Player player) {
        this.playerSound(player, SoundEvents.BUNDLE_REMOVE_ONE, 0.8f);
    }

    private void playInsertSound(Player player) {
        this.playerSound(player, SoundEvents.BUNDLE_INSERT, 0.8f);
        this.playerSound(player, SoundEvents.BONE_MEAL_USE, 0.4f);
    }

    private void playerSound(Player player, SoundEvent event, float volume) {
        float randPitch = 0.8f + player.level().random.nextFloat() * 0.4f;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.playNotifySound(event, SoundSource.PLAYERS, volume, randPitch);
        } else {
            player.playSound(event, volume, randPitch);
        }
    }
}

