/*
 * Decompiled with CFR 0.152.
 */
package dev.dhyces.compostbag;

import dev.dhyces.compostbag.CompostBag;
import dev.dhyces.compostbag.CompostBagClient;
import dev.dhyces.compostbag.item.CompostBagItem;
import dev.dhyces.compostbag.tooltip.ClientCompostBagTooltip;
import dev.dhyces.compostbag.tooltip.CompostBagTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ComposterBlock;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.lwjgl.glfw.GLFW;

public class NeoCompostBagClient {
    static void init(IEventBus modBus) {
        modBus.addListener(NeoCompostBagClient::clientSetup);
        modBus.addListener(NeoCompostBagClient::registerTooltipComponents);
        NeoForge.EVENT_BUS.addListener(NeoCompostBagClient::cancelOtherTooltips);
        NeoForge.EVENT_BUS.addListener(NeoCompostBagClient::renderTooltipWhileHovering);
        NeoForge.EVENT_BUS.addListener(NeoCompostBagClient::multiDrop);
        NeoForge.EVENT_BUS.addListener(NeoCompostBagClient::cancelRightClickTick);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)CompostBag.COMPOST_BAG_ITEM.value()), (ResourceLocation)CompostBag.id("filled"), (ItemPropertyFunction)((ClampedItemPropertyFunction)CompostBagClient::bonemealFullness)));
    }

    private static void registerTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(CompostBagTooltip.class, ClientCompostBagTooltip::new);
    }

    private static void cancelOtherTooltips(RenderTooltipEvent.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2).getMenu().getCarried().getItem() instanceof CompostBagItem && event.getComponents().stream().noneMatch(c -> c instanceof ClientCompostBagTooltip)) {
            event.setCanceled(true);
        }
    }

    private static void renderTooltipWhileHovering(ContainerScreenEvent.Render.Foreground e) {
        AbstractContainerScreen screen = e.getContainerScreen();
        ItemStack bag = ItemStack.EMPTY;
        Slot hoveredSlot = screen.getSlotUnderMouse();
        ItemStack carried = screen.getMenu().getCarried();
        if (hoveredSlot != null && hoveredSlot.getItem().getItem() instanceof CompostBagItem && !carried.isEmpty()) {
            bag = hoveredSlot.getItem();
        } else if (carried.getItem() instanceof CompostBagItem) {
            bag = carried;
        }
        if (bag.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics guiGraphics = e.getGuiGraphics();
        int x = e.getMouseX() - screen.getGuiLeft();
        int y = e.getMouseY() - screen.getGuiTop();
        guiGraphics.renderTooltip(mc.font, bag, x, y);
    }

    private static void multiDrop(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer clientPlayer = mc.player;
        Screen s = mc.screen;
        if (clientPlayer == null || !(s instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen screen = (AbstractContainerScreen)s;
        if (GLFW.glfwGetMouseButton((long)mc.getWindow().getWindow(), (int)1) != 1) {
            return;
        }
        Slot slot = screen.getSlotUnderMouse();
        if (slot != null && slot.hasItem() && screen.getMenu().canTakeItemForPickAll(slot.getItem(), slot)) {
            ItemStack item = slot.getItem();
            ItemStack carried = screen.getMenu().getCarried();
            if (carried.isEmpty() || ComposterBlock.getValue((ItemStack)carried) == 0.0f) {
                return;
            }
            if (CompostBagClient.getTickerInstance().tick() && item.getItem() instanceof CompostBagItem) {
                if (screen instanceof CreativeModeInventoryScreen) {
                    screen.getMenu().clicked(slot.index == 0 ? slot.getContainerSlot() : slot.index, 1, ClickType.PICKUP, (Player)clientPlayer);
                } else {
                    mc.gameMode.handleInventoryMouseClick(screen.getMenu().containerId, slot.index, 1, ClickType.PICKUP, (Player)clientPlayer);
                }
            }
        }
    }

    private static void cancelRightClickTick(ScreenEvent.MouseButtonReleased.Pre event) {
        Screen screen = Minecraft.getInstance().screen;
        if (event.getButton() == 1 && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (CompostBagClient.getTickerInstance().inProgress()) {
                containerScreen.isQuickCrafting = false;
                event.setCanceled(true);
            }
            CompostBagClient.getTickerInstance().restart();
        }
    }
}

