/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Color;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.impl.ui.StyledElement;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.JadeCodecs;

public abstract class BoxStyle
implements Cloneable {
    private static final int[] DEFAULT_PADDING = new int[]{4, 4, 4, 4};
    public static final Codec<GradientBorder> GRADIENT_BORDER_CODEC = RecordCodecBuilder.create(i -> i.group((App)JadeCodecs.floatArrayCodec(4, (Codec<Float>)Codec.FLOAT).optionalFieldOf("boxProgressOffset").forGetter($ -> Optional.ofNullable($.boxProgressOffset)), (App)ColorPalette.CODEC.optionalFieldOf("boxProgressColors", (Object)ColorPalette.DEFAULT).forGetter($ -> $.boxProgressColors), (App)JadeCodecs.intArrayCodec(4, (Codec<Integer>)Codec.INT).optionalFieldOf("padding").forGetter($ -> Optional.ofNullable($.padding)), (App)Color.CODEC.optionalFieldOf("backgroundColor", (Object)-1).forGetter($ -> $.bgColor), (App)JadeCodecs.intArrayCodec(4, Color.CODEC).fieldOf("borderColor").forGetter($ -> $.borderColor), (App)Codec.FLOAT.optionalFieldOf("borderWidth", (Object)Float.valueOf(1.0f)).forGetter($ -> Float.valueOf($.borderWidth)), (App)Codec.BOOL.optionalFieldOf("roundCorner").forGetter($ -> Optional.ofNullable($.roundCorner))).apply((Applicative)i, GradientBorder::new));
    public static final Codec<SpriteBase> SPRITE_BASE_CODEC = RecordCodecBuilder.create(i -> i.group((App)JadeCodecs.floatArrayCodec(4, (Codec<Float>)Codec.FLOAT).optionalFieldOf("boxProgressOffset").forGetter($ -> Optional.ofNullable($.boxProgressOffset)), (App)ColorPalette.CODEC.optionalFieldOf("boxProgressColors", (Object)ColorPalette.DEFAULT).forGetter($ -> $.boxProgressColors), (App)JadeCodecs.intArrayCodec(4, (Codec<Integer>)Codec.INT).optionalFieldOf("padding").forGetter($ -> Optional.ofNullable($.padding)), (App)ResourceLocation.CODEC.fieldOf("sprite").forGetter($ -> $.sprite), (App)ResourceLocation.CODEC.optionalFieldOf("withIconSprite").forGetter($ -> Optional.ofNullable($.withIconSprite))).apply((Applicative)i, SpriteBase::new));
    public static final Codec<BoxStyle> CODEC = Codec.either(GRADIENT_BORDER_CODEC, SPRITE_BASE_CODEC).xmap($ -> (BoxStyle)$.map(Function.identity(), Function.identity()), $ -> $ instanceof GradientBorder ? Either.left((Object)((GradientBorder)$)) : Either.right((Object)((SpriteBase)$)));
    public final float[] boxProgressOffset;
    public final int[] padding;
    public ColorPalette boxProgressColors;

    public BoxStyle(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding) {
        this.boxProgressOffset = boxProgressOffset.orElse(null);
        this.boxProgressColors = boxProgressColors;
        this.padding = padding.orElseGet(() -> (int[])DEFAULT_PADDING.clone());
    }

    public static BoxStyle getNestedBox() {
        return IThemeHelper.get().theme().nestedBoxStyle;
    }

    public static BoxStyle getViewGroup() {
        return IThemeHelper.get().theme().viewGroupStyle;
    }

    public static GradientBorder getTransparent() {
        return GradientBorder.TRANSPARENT;
    }

    public static BoxStyle getSprite(ResourceLocation sprite, @Nullable int[] padding) {
        return new SpriteBase(Optional.empty(), ColorPalette.DEFAULT, Optional.ofNullable(padding), sprite, Optional.empty());
    }

    public abstract void render(GuiGraphics var1, StyledElement var2, float var3, float var4, float var5, float var6, float var7);

    public abstract float borderWidth();

    public float boxProgressOffset(ScreenDirection dir) {
        return this.boxProgressOffset == null ? 0.0f : this.boxProgressOffset[dir.ordinal()];
    }

    public int padding(ScreenDirection dir) {
        return ((int[])MoreObjects.firstNonNull((Object)this.padding, (Object)DEFAULT_PADDING))[dir.ordinal()];
    }

    public abstract BoxStyle clone();

    public boolean hasRoundCorner() {
        return false;
    }

    public static class GradientBorder
    extends BoxStyle {
        public static final GradientBorder TRANSPARENT = new GradientBorder(Optional.empty(), ColorPalette.DEFAULT, Optional.empty(), -1, new int[]{-1, -1, -1, -1}, 0.0f, Optional.of(false));
        public static final GradientBorder DEFAULT_NESTED_BOX = new GradientBorder(Optional.empty(), ColorPalette.DEFAULT, Optional.empty(), -1, new int[]{-8355712, -8355712, -8355712, -8355712}, 1.0f, Optional.empty());
        public static final GradientBorder DEFAULT_VIEW_GROUP = new GradientBorder(Optional.empty(), ColorPalette.DEFAULT, Optional.of(new int[]{2, 2, 2, 2}), 0x44444444, new int[]{0x44444444, 0x44444444, 0x44444444, 0x44444444}, 0.75f, Optional.empty());
        public int bgColor;
        public int[] borderColor;
        public float borderWidth;
        @Nullable
        public Boolean roundCorner;

        private GradientBorder(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding, int bgColor, int[] borderColor, float borderWidth, Optional<Boolean> roundCorner) {
            super(boxProgressOffset, boxProgressColors, padding);
            this.bgColor = bgColor;
            this.borderColor = borderColor;
            this.borderWidth = borderWidth;
            this.roundCorner = roundCorner.orElse(null);
        }

        @Override
        public float borderWidth() {
            return this.borderWidth;
        }

        @Override
        public void render(GuiGraphics guiGraphics, StyledElement element, float x, float y, float w, float h, float alpha) {
            boolean roundCorner = this.hasRoundCorner();
            if (this.bgColor != -1) {
                int bg = IWailaConfig.IConfigOverlay.applyAlpha(this.bgColor, alpha);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + this.borderWidth, y + this.borderWidth, w - this.borderWidth - this.borderWidth, h - this.borderWidth - this.borderWidth, bg, bg);
                if (roundCorner) {
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y - 1.0f, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x - 1.0f, y, 1.0f, h, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w, y, 1.0f, h, bg, bg);
                }
            }
            if (this.borderWidth > 0.0f) {
                int[] borderColors = new int[4];
                for (int i = 0; i < 4; ++i) {
                    if (this.borderColor[i] == -1) continue;
                    borderColors[i] = IWailaConfig.IConfigOverlay.applyAlpha(this.borderColor[i], alpha);
                }
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + this.borderWidth, this.borderWidth, h - this.borderWidth - this.borderWidth, borderColors[0], borderColors[3]);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w - this.borderWidth, y + this.borderWidth, this.borderWidth, h - this.borderWidth - this.borderWidth, borderColors[1], borderColors[2]);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y, w, this.borderWidth, borderColors[0], borderColors[1]);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h - this.borderWidth, w, this.borderWidth, borderColors[3], borderColors[2]);
            }
        }

        @Override
        public GradientBorder clone() {
            return new GradientBorder(JadeCodecs.nullableClone(this.boxProgressOffset), this.boxProgressColors, JadeCodecs.nullableClone(this.padding), this.bgColor, this.borderColor, this.borderWidth, Optional.ofNullable(this.roundCorner));
        }

        @Override
        public boolean hasRoundCorner() {
            return this.roundCorner == null ? !IWailaConfig.get().getOverlay().getSquare() : this.roundCorner;
        }
    }

    public static class SpriteBase
    extends BoxStyle {
        public ResourceLocation sprite;
        @Nullable
        public ResourceLocation withIconSprite;

        public SpriteBase(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding, ResourceLocation sprite, Optional<ResourceLocation> withIconSprite) {
            super(boxProgressOffset, boxProgressColors, padding);
            this.sprite = sprite;
            this.withIconSprite = withIconSprite.orElse(null);
        }

        public static void blitSprite(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int i, int j, int k, int l, int m) {
            GuiSpriteScaling guiSpriteScaling;
            GuiSpriteManager sprites = Minecraft.getInstance().getGuiSprites();
            TextureAtlasSprite textureAtlasSprite = sprites.getSprite(resourceLocation);
            GuiSpriteScaling guiSpriteScaling2 = guiSpriteScaling = sprites.getSpriteScaling(textureAtlasSprite);
            Objects.requireNonNull(guiSpriteScaling2);
            GuiSpriteScaling guiSpriteScaling3 = guiSpriteScaling2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuiSpriteScaling.Stretch.class, GuiSpriteScaling.Tile.class, GuiSpriteScaling.NineSlice.class}, (Object)guiSpriteScaling3, n)) {
                case 0: {
                    GuiSpriteScaling.Stretch ignored = (GuiSpriteScaling.Stretch)guiSpriteScaling3;
                    guiGraphics.blitSprite(resourceLocation, i, j, k, l, m);
                    break;
                }
                case 1: {
                    GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)guiSpriteScaling3;
                    guiGraphics.blitTiledSprite(textureAtlasSprite, i, j, k, l, m, 0, 0, tile.width(), tile.height(), tile.width(), tile.height());
                    break;
                }
                case 2: {
                    GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiSpriteScaling3;
                    SpriteBase.blitNineSlicedSprite(guiGraphics, textureAtlasSprite, nineSlice, i, j, k, l, m);
                    break;
                }
            }
        }

        public static void blitNineSlicedSprite(GuiGraphics guiGraphics, TextureAtlasSprite textureAtlasSprite, GuiSpriteScaling.NineSlice nineSlice, int i, int j, int k, int l, int m) {
            GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
            int n = Math.min(border.left(), l / 2);
            int o = Math.min(border.right(), l / 2);
            int p = Math.min(border.top(), m / 2);
            int q = Math.min(border.bottom(), m / 2);
            if (l == nineSlice.width() && m == nineSlice.height()) {
                guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, l, m);
                return;
            }
            if (m == nineSlice.height()) {
                guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, n, m);
                guiGraphics.blitTiledSprite(textureAtlasSprite, i + n, j, k, l - o - n, m, n, 0, nineSlice.width() - o - n, nineSlice.height(), nineSlice.width(), nineSlice.height());
                guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, i + l - o, j, k, o, m);
                return;
            }
            if (l == nineSlice.width()) {
                guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, l, p);
                guiGraphics.blitTiledSprite(textureAtlasSprite, i, j + p, k, l, m - q - p, 0, p, nineSlice.width(), nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
                guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, i, j + m - q, k, l, q);
                return;
            }
            guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, i, j, k, n, p);
            guiGraphics.blitTiledSprite(textureAtlasSprite, i + n, j, k, l - o - n, p, n, 0, nineSlice.width() - o - n, p, nineSlice.width(), nineSlice.height());
            guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, i + l - o, j, k, o, p);
            guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, i, j + m - q, k, n, q);
            guiGraphics.blitTiledSprite(textureAtlasSprite, i + n, j + m - q, k, l - o - n, q, n, nineSlice.height() - q, nineSlice.width() - o - n, q, nineSlice.width(), nineSlice.height());
            guiGraphics.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, nineSlice.height() - q, i + l - o, j + m - q, k, o, q);
            guiGraphics.blitTiledSprite(textureAtlasSprite, i, j + p, k, n, m - q - p, 0, p, n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            guiGraphics.blitTiledSprite(textureAtlasSprite, i + n, j + p, k, l - o - n, m - q - p, n, p, nineSlice.width() - o - n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            guiGraphics.blitTiledSprite(textureAtlasSprite, i + l - o, j + p, k, o, m - q - p, nineSlice.width() - o, p, o, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
        }

        @Override
        public void render(GuiGraphics guiGraphics, StyledElement element, float x, float y, float w, float h, float alpha) {
            ResourceLocation texture = this.sprite;
            if (this.withIconSprite != null && element.getIcon() != null) {
                texture = this.withIconSprite;
            }
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            SpriteBase.blitSprite(guiGraphics, texture, Math.round(x), Math.round(y), 0, Math.round(w), Math.round(h));
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public float borderWidth() {
            return 0.0f;
        }

        @Override
        public SpriteBase clone() {
            return new SpriteBase(JadeCodecs.nullableClone(this.boxProgressOffset), this.boxProgressColors, JadeCodecs.nullableClone(this.padding), this.sprite, Optional.ofNullable(this.withIconSprite));
        }
    }
}

